<?php
session_start();

if(!isset($_SESSION['access_token']))
{
    http_response_code(403);
    die('Access Denied');
}

if($_GET['path'] == null)
{
    http_response_code(405);
    die('Access Denied');
}

if($_GET['path'] != 'index.php')
{
    http_response_code(405);
    die('Access Denied');
}

if(!empty($_SESSION['login_exp']))
{
    header("Location: dashboard?path=index.php");
    exit;
}

if (isset($_SESSION['flash_message'])) {
    $flash = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

$config = json_decode(file_get_contents(__DIR__ . "/../../config/access.json"), true);
if (!isset($config) || !is_array($config)) {
    die("Konfigurasi tidak ditemukan atau tidak valid.");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (empty($_SESSION['login_exp'])) {
        if ($_POST['pass'] == $config['token_login']) {
            $_SESSION['login_exp'] = time();
            header("Location: dashboard?path=index.php");
            ob_flush();
        } else {
            $_SESSION['flash_message'] = [
                'type' => 'danger',
                'message' => 'Login invalid!'
            ];
            
            header("Location: ?path=index.php");
            ob_flush();
        }
    } else {
        $_SESSION['login_exp'] = time();
        header("Location: dashboard?path=index.php");
        ob_flush();
    }
}

?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->
<?php
    $rootFolder = basename($_SERVER['DOCUMENT_ROOT']);
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . str_replace('/pages', '', dirname($_SERVER['SCRIPT_NAME']));
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>

<?php
$config = json_decode(file_get_contents(__DIR__ . "/../../config/theme.json"), true);

if (!isset($config) || !is_array($config)) {
    die("Konfigurasi tidak ditemukan atau tidak valid.");
}
?>
<?php if ($config['bgImage_change'] == '1'): ?>
<style>
    
    body.authentication-background {
        background-image: url("assets/<?= htmlspecialchars($config['bgImage_select']); ?>") !important;
        background-repeat: no-repeat !important;
        background-position: center center !important;
        background-attachment: fixed !important;
        background-size: cover !important;
        background-size: 100vw 100vh !important;
    }
    
    .multi-glow {
      animation: flickerGlow 2s infinite;
      box-shadow:
        0 0 10px red,
        0 0 20px orange,
        0 0 30px yellow,
        0 0 40px green,
        0 0 50px blue,
        0 0 60px indigo,
        0 0 70px violet;
    }
    
    @keyframes flickerGlow {
      0%, 100% {
        opacity: 1;
        transform: scale(1);
      }
      50% {
        opacity: 0.7;
        transform: scale(1.03);
      }
    }

</style>
<?php endif; ?>

<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>

<?php ob_start(); ?>
<body class="authentication-background">
<?php $body = ob_get_clean(); ?>

            <div class="container-lg">
                <div class="row justify-content-center authentication authentication-basic align-items-center h-100">
                    <div class="col-xxl-4 col-xl-5 col-lg-5 col-md-6 col-sm-8 col-12">
                        <div class="card custom-card">
                            <div class="top-left"></div>
                            <div class="top-right"></div>
                            <div class="bottom-left"></div>
                            <div class="bottom-right"></div>
                            <div class="card-body p-5 multi-glow">
                                <div class="mb-3 d-flex justify-content-center">
                                    <a href="">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/money.png" alt="logo" class="desktop-logo">
                                        <img src="<?php echo $baseUrl; ?>/assets/images/money.png" alt="logo" class="desktop-dark">
                                    </a>
                                </div>
                                <?php if (!empty($flash)): ?>
        				        <div class="alert alert-<?php echo htmlspecialchars($flash['type']); ?>">
        				        <?php echo htmlspecialchars($flash['message']); ?>
        				        </div>
        				        <?php endif; ?>
                                <p class="h5 mb-3 text-center">Login Access</p>
                                <form action="?path=index.php" method="POST">
                                    <div class="row gy-3">
                                    <div class="col-xl-12 mb-2">
                                        <label for="lockscreen-password" class="form-label text-default">Token</label>
                                        <div class="position-relative">
                                            <input type="password" class="form-control create-password-input" id="lockscreen-password" placeholder="Please type your token" name="pass">
                                            <a href="javascript:void(0);" class="show-password-button text-muted" onclick="createpassword('lockscreen-password',this)"  id="button-addon2"><i class="ri-eye-off-line align-middle"></i></a>
                                        </div>
                                        <div class="mt-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="defaultCheck1">
                                                <label class="form-check-label text-muted fw-normal" for="defaultCheck1">
                                                    Remember me ?
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xl-12 d-grid mt-2">
                                        <button class="btn btn-primary">Login</button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    
<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>

        <!-- Show Password JS -->
        <script src="<?php echo $baseUrl; ?>/assets/js/show-password.js"></script>

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include 'layouts/custom-base.php'; ?>
<!-- This code use for render base file -->